/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;

public class IntegerConverter
extends AbstractConverter<Integer> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC, CellType.STRING};

    public IntegerConverter() {
        super(supportedCellTypes);
    }

    @Override
    public Integer readCell(Cell cell) {
        Integer returnValue = null;
        if (null != cell) {
            Double cellValue;
            CellType cellType = this.getCellType(cell);
            if (CellType.NUMERIC == cellType) {
                returnValue = this.getCellValueAsNumeric(cell);
            } else if (CellType.STRING == cellType && null != (cellValue = Double.valueOf(Double.parseDouble(cell.getRichStringCellValue().getString().trim())))) {
                returnValue = cellValue.intValue();
            }
        }
        return returnValue;
    }

    private Integer getCellValueAsNumeric(Cell cell) {
        Integer returnValue = null;
        Double cellValue = null;
        try {
            cellValue = cell.getNumericCellValue();
        }
        catch (IllegalStateException isex) {
            cellValue = Double.parseDouble(cell.getRichStringCellValue().getString().trim());
        }
        if (null != cellValue) {
            returnValue = cellValue.intValue();
        }
        return returnValue;
    }

    @Override
    public Integer readCell(Cell cell, String regex) {
        return this.readCell(cell);
    }

    @Override
    public void writeCell(Cell cell, Integer value) {
        if (null != value) {
            cell.setCellValue((double)value.intValue());
        }
    }
}

