/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;

public class ShortConverter
extends AbstractConverter<Short> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC, CellType.STRING};

    public ShortConverter() {
        super(supportedCellTypes);
    }

    @Override
    public Short readCell(Cell cell) {
        Short returnValue = null;
        if (this.isValidCell(cell)) {
            CellType cellType = this.getCellType(cell);
            if (CellType.NUMERIC == cellType) {
                returnValue = this.getCellValueNumeric(cell);
            } else if (CellType.STRING == cellType) {
                returnValue = this.getCellValueAsString(cell);
            }
        }
        return returnValue;
    }

    private Short getCellValueAsString(Cell cell) {
        Double bla = null;
        bla = Double.parseDouble(cell.getRichStringCellValue().toString());
        return bla != null ? Short.valueOf(bla.shortValue()) : null;
    }

    private Short getCellValueNumeric(Cell cell) {
        Double cellValue = null;
        try {
            cellValue = cell.getNumericCellValue();
        }
        catch (IllegalStateException isex) {
            cellValue = Double.parseDouble(cell.getRichStringCellValue().getString().trim());
        }
        return cellValue != null ? Short.valueOf(cellValue.shortValue()) : null;
    }

    private boolean isValidCell(Cell cell) {
        return cell != null && this.isCellTypeSupported(cell);
    }

    @Override
    public Short readCell(Cell cell, String regex) {
        return this.readCell(cell);
    }

    @Override
    public void writeCell(Cell cell, Short value) {
        if (null != value) {
            cell.setCellValue(value.doubleValue());
        }
    }
}

