/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import nl.bstoi.poiparser.core.exception.PoiParserException;
import nl.bstoi.poiparser.core.strategy.PoiType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractPoiParserFactory {
    private static final Log log = LogFactory.getLog(AbstractPoiParserFactory.class);
    private PoiType poiType;
    protected boolean createHeaderRow = false;
    protected boolean ignoreFirstRow = false;
    protected Properties columnHeaderProperties;

    protected Sheet getSheetFromInputStream(InputStream inputStream, String sheetName) throws PoiParserException {
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workbook.getSheet(sheetName);
            return sheet;
        }
        catch (IllegalArgumentException e) {
            throw new PoiParserException("Cannot read input stream", e);
        }
        catch (IOException e) {
            throw new PoiParserException("Cannot read input stream", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    protected Workbook createNewWorkBook(PoiType poiType) {
        XSSFWorkbook workBook;
        if (null == poiType) {
            poiType = PoiType.HSSF;
        }
        switch (poiType) {
            case XSSF: {
                workBook = new XSSFWorkbook();
                break;
            }
            case SXSSF: {
                workBook = new SXSSFWorkbook();
                break;
            }
            default: {
                workBook = new HSSFWorkbook();
            }
        }
        return workBook;
    }

    public PoiType getPoiType() {
        return this.poiType;
    }

    public void setCreateHeaderRow(boolean createHeaderRow) {
        this.createHeaderRow = createHeaderRow;
    }

    public void setIgnoreFirstRow(boolean ignoreFirstRow) {
        this.ignoreFirstRow = ignoreFirstRow;
    }

    public void setColumnHeaderProperties(Properties columnHeaderProperties) {
        this.columnHeaderProperties = columnHeaderProperties;
    }
}

