/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;

public class LongConverter
extends AbstractConverter<Long> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC, CellType.STRING};

    public LongConverter() {
        super(supportedCellTypes);
    }

    @Override
    public Long readCell(Cell cell) {
        Long returnValue = null;
        if (this.isValidCell(cell)) {
            CellType cellType = this.getCellType(cell);
            if (CellType.NUMERIC == cellType) {
                returnValue = this.getValueAsNumeric(cell);
            } else if (CellType.STRING == cellType) {
                returnValue = this.getCellValueAsString(cell);
            }
        }
        return returnValue;
    }

    private Long getCellValueAsString(Cell cell) {
        Long returnValue = null;
        Double cellValue = Double.parseDouble(cell.getRichStringCellValue().getString().trim());
        if (null != cellValue) {
            returnValue = cellValue.longValue();
        }
        return returnValue;
    }

    private Long getValueAsNumeric(Cell cell) {
        Double cellValue;
        Long returnValue = null;
        try {
            cellValue = cell.getNumericCellValue();
        }
        catch (IllegalStateException isex) {
            cellValue = Double.parseDouble(cell.getRichStringCellValue().getString().trim());
        }
        if (null != cellValue) {
            returnValue = cellValue.longValue();
        }
        return returnValue;
    }

    private boolean isValidCell(Cell cell) {
        return null != cell && this.isCellTypeSupported(cell);
    }

    @Override
    public Long readCell(Cell cell, String regex) {
        return this.readCell(cell);
    }

    @Override
    public void writeCell(Cell cell, Long value) {
        if (null != value) {
            cell.setCellValue((double)value.longValue());
        }
    }
}

