/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import nl.bstoi.poiparser.api.ClassDescriber;
import nl.bstoi.poiparser.api.strategy.annotations.Cell;
import nl.bstoi.poiparser.api.strategy.annotations.Embedded;
import nl.bstoi.poiparser.core.exception.PoiParserRuntimeException;
import nl.bstoi.poiparser.core.strategy.CellDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class AnnotatedClassDescriber
implements ClassDescriber {
    private static final String[] DEFAULT_IGNORED_PROPERTYNAMES = new String[]{"class"};
    private String[] ignorePropertyName = DEFAULT_IGNORED_PROPERTYNAMES;
    private static AnnotatedClassDescriber instance;

    private AnnotatedClassDescriber() {
    }

    public static AnnotatedClassDescriber getInstance() {
        if (null == instance) {
            instance = new AnnotatedClassDescriber();
        }
        return instance;
    }

    @Override
    public Set<CellDescriptor> getCellDescriptorsForClass(Class clazz) {
        return this.getCellDescriptorsForClass(null, clazz);
    }

    private Set<CellDescriptor> getCellDescriptorsForClass(String propertyName, Class clazz) {
        HashSet<CellDescriptor> cellDescriptors = new HashSet<CellDescriptor>();
        if (clazz.getSuperclass() != Object.class) {
            this.addEmbeddedCellDescriptors(cellDescriptors, this.getCellDescriptorsForClass(propertyName, clazz.getSuperclass()));
        }
        for (PropertyDescriptor propertyDescriptor : PropertyUtils.getPropertyDescriptors((Class)clazz)) {
            Class<?> type;
            Cell cell;
            block9: {
                Method method;
                if (!this.isNotIgnoredProperty(propertyDescriptor)) continue;
                cell = null;
                type = null;
                try {
                    Field field = clazz.getDeclaredField(propertyDescriptor.getDisplayName());
                    cell = field.getAnnotation(Cell.class);
                    if (this.isCorrectEmbeddedField(field) && this.hasNoTypeRecursion(clazz, field.getType())) {
                        this.addEmbeddedCellDescriptors(cellDescriptors, this.getCellDescriptorsForClass(field.getName(), field.getType()));
                    }
                    if (cell == null) {
                        method = propertyDescriptor.getReadMethod();
                        if (null != method && method.getDeclaringClass().equals(clazz)) {
                            cell = method.getAnnotation(Cell.class);
                            type = method.getReturnType();
                        }
                    } else {
                        type = field.getType();
                    }
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (NoSuchFieldException e) {
                    method = propertyDescriptor.getReadMethod();
                    if (null == method || !method.getDeclaringClass().equals(clazz)) break block9;
                    cell = method.getAnnotation(Cell.class);
                    type = method.getReturnType();
                }
            }
            if (null == cell) continue;
            this.addCellDescriptor(cellDescriptors, this.createCellDescriptor(this.getPropertyName(propertyName, propertyDescriptor.getDisplayName()), cell, type));
        }
        return cellDescriptors;
    }

    private void addEmbeddedCellDescriptors(Set<CellDescriptor> cellDescriptors, Set<CellDescriptor> embeddedCellDescriptors) {
        for (CellDescriptor embeddedCellDescriptor : embeddedCellDescriptors) {
            this.addCellDescriptor(cellDescriptors, embeddedCellDescriptor);
        }
    }

    private void addCellDescriptor(Set<CellDescriptor> cellDescriptors, CellDescriptor embeddedCellDescriptor) {
        if (cellDescriptors.contains(embeddedCellDescriptor)) {
            throw new PoiParserRuntimeException(String.format("Duplicate column definition found column %s is defined more than once", embeddedCellDescriptor.getColumnNumber()));
        }
        cellDescriptors.add(embeddedCellDescriptor);
    }

    private CellDescriptor createCellDescriptor(String propertyName, Cell cell, Class type) {
        CellDescriptor cellDescriptor = new CellDescriptor(propertyName, cell.columnNumber(), type);
        cellDescriptor.setRequired(cell.required());
        cellDescriptor.setReadIgnore(cell.readIgnore());
        cellDescriptor.setWriteIgnore(cell.writeIgnore());
        cellDescriptor.setRegex(cell.regex());
        return cellDescriptor;
    }

    private String getPropertyName(String propertyName, String fieldName) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return fieldName;
        }
        return propertyName + "." + fieldName;
    }

    private boolean isNotIgnoredProperty(PropertyDescriptor propertyDescriptor) {
        return !ArrayUtils.contains((Object[])this.ignorePropertyName, (Object)propertyDescriptor.getDisplayName());
    }

    private boolean isEmbeddedField(Field field) {
        if (null != field) {
            return null != field.getAnnotation(Embedded.class);
        }
        return false;
    }

    private boolean hasCellAnnotationOnField(Field field) {
        if (null != field) {
            return null != field.getAnnotation(Cell.class);
        }
        return false;
    }

    private boolean isCorrectEmbeddedField(Field field) {
        if (this.isEmbeddedField(field)) {
            if (!this.hasCellAnnotationOnField(field)) {
                return true;
            }
            throw new PoiParserRuntimeException("A field cannot be annotated with @Cell and @Embedded");
        }
        return false;
    }

    private boolean hasNoTypeRecursion(Class declaringClass, Class fieldType) {
        if (!declaringClass.equals(fieldType)) {
            return true;
        }
        throw new PoiParserRuntimeException("Declaring class cannot be the same as the field type (recursion is not supported)");
    }
}

