/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import java.util.Date;
import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public class DateConverter
extends AbstractConverter<Date> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.NUMERIC};

    protected DateConverter() {
        super(supportedCellTypes);
    }

    @Override
    public Date readCell(Cell cell) {
        Date returnValue = null;
        if (this.hasValidCell(cell)) {
            returnValue = cell.getDateCellValue();
        }
        return returnValue;
    }

    private boolean hasValidCell(Cell cell) {
        return null != cell && this.isCellTypeSupported(cell) && DateUtil.isCellDateFormatted((Cell)cell);
    }

    @Override
    public Date readCell(Cell cell, String regex) {
        return this.readCell(cell);
    }

    @Override
    public void writeCell(Cell cell, Date value) {
        if (null != value) {
            cell.setCellValue(value);
        }
    }
}

