/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.factory;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.bstoi.poiparser.api.strategy.converter.Converter;
import nl.bstoi.poiparser.core.exception.NonExistentConverterException;
import nl.bstoi.poiparser.core.strategy.converter.BigDecimalConverter;
import nl.bstoi.poiparser.core.strategy.converter.BooleanConverter;
import nl.bstoi.poiparser.core.strategy.converter.CalendarConverter;
import nl.bstoi.poiparser.core.strategy.converter.DateConverter;
import nl.bstoi.poiparser.core.strategy.converter.IntegerConverter;
import nl.bstoi.poiparser.core.strategy.converter.LongConverter;
import nl.bstoi.poiparser.core.strategy.converter.ShortConverter;
import nl.bstoi.poiparser.core.strategy.converter.StringConverter;

public class DefaultConverterFactory {
    private final Map<Class<?>, Class<? extends Converter<?>>> typeConvertorMap = new ConcurrentHashMap();

    public DefaultConverterFactory() {
        this.registerConverter(String.class, StringConverter.class);
        this.registerConverter(Short.class, ShortConverter.class);
        this.registerConverter(Short.TYPE, ShortConverter.class);
        this.registerConverter(Integer.class, IntegerConverter.class);
        this.registerConverter(Integer.TYPE, IntegerConverter.class);
        this.registerConverter(Long.class, LongConverter.class);
        this.registerConverter(Long.TYPE, LongConverter.class);
        this.registerConverter(BigDecimal.class, BigDecimalConverter.class);
        this.registerConverter(Date.class, DateConverter.class);
        this.registerConverter(Calendar.class, CalendarConverter.class);
        this.registerConverter(Boolean.class, BooleanConverter.class);
        this.registerConverter(Boolean.TYPE, BooleanConverter.class);
    }

    public Converter<?> getConverter(Class<?> type) throws InstantiationException, IllegalAccessException, NonExistentConverterException {
        if (this.hasConverterForType(type)) {
            return this.typeConvertorMap.get(type).newInstance();
        }
        throw new NonExistentConverterException(String.format("No converter found for type %s", type.getCanonicalName()));
    }

    public void registerConverter(Class<?> type, Class<? extends Converter<?>> converterType) {
        this.typeConvertorMap.put(type, converterType);
    }

    public boolean hasConverterForType(Class<?> type) {
        return this.typeConvertorMap.containsKey(type);
    }
}

