/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy.converter;

import java.text.NumberFormat;
import java.util.regex.Pattern;
import nl.bstoi.poiparser.core.strategy.converter.AbstractConverter;
import nl.bstoi.poiparser.core.strategy.converter.CellType;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;

public class StringConverter
extends AbstractConverter<String> {
    private static final CellType[] supportedCellTypes = new CellType[]{CellType.STRING, CellType.NUMERIC};

    public StringConverter() {
        super(supportedCellTypes);
    }

    @Override
    public String readCell(Cell cell) {
        return this.readCell(cell, null);
    }

    @Override
    public String readCell(Cell cell, String regex) {
        String returnValue = null;
        if (this.isValidCell(cell)) {
            CellType cellType = this.getCellType(cell);
            if (this.isCellOfTypeStringAndHasRegex(regex, cellType)) {
                returnValue = this.readCellValueAsStringWithRegex(cell, regex, returnValue);
            } else if (CellType.STRING == cellType) {
                returnValue = cell.getRichStringCellValue().getString();
            } else if (this.isCellNumericAndDateFormatted(cell, cellType)) {
                returnValue = cell.getDateCellValue().toString();
            } else if (CellType.NUMERIC == cellType) {
                returnValue = this.getCellValueAsNumeric(cell);
            }
        }
        return returnValue;
    }

    private String readCellValueAsStringWithRegex(Cell cell, String regex, String returnValue) {
        Pattern pattern = Pattern.compile(regex);
        if (pattern.matcher(cell.getRichStringCellValue().getString()).matches()) {
            returnValue = cell.getRichStringCellValue().getString();
        }
        return returnValue;
    }

    private String getCellValueAsNumeric(Cell cell) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(cell.getNumericCellValue());
    }

    private boolean isCellNumericAndDateFormatted(Cell cell, CellType cellType) {
        return CellType.NUMERIC == cellType && DateUtil.isCellDateFormatted((Cell)cell);
    }

    private boolean isCellOfTypeStringAndHasRegex(String regex, CellType cellType) {
        return CellType.STRING == cellType && StringUtils.isNotBlank((String)regex);
    }

    private boolean isValidCell(Cell cell) {
        return null != cell && this.isCellTypeSupported(cell);
    }

    @Override
    public void writeCell(Cell cell, String value) {
        if (cell != null) {
            CreationHelper creationHelper = cell.getSheet().getWorkbook().getCreationHelper();
            cell.setCellValue(creationHelper.createRichTextString(value));
        }
    }
}

