/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.bstoi.poiparser.api.strategy.converter.Converter;
import nl.bstoi.poiparser.core.exception.PoiParserException;
import nl.bstoi.poiparser.core.exception.RequiredFieldPoiParserException;
import nl.bstoi.poiparser.core.strategy.CellDescriptor;
import nl.bstoi.poiparser.core.strategy.factory.DefaultConverterFactory;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class AbstractReadPoiParser<T> {
    private static final Log log = LogFactory.getLog(AbstractReadPoiParser.class);
    private final Class<T> clazz;
    private final Set<CellDescriptor> cellDescriptors;
    private final Sheet sheet;
    private final boolean ignoreEmptyRows = true;
    private boolean ignoreFirstRow = false;
    private final DefaultConverterFactory DEFAULTCONVERTERFACTORY;
    private DefaultConverterFactory converterFactory = this.DEFAULTCONVERTERFACTORY = new DefaultConverterFactory();

    public AbstractReadPoiParser(Set<CellDescriptor> cellDescriptors, Sheet sheet, Class<T> clazz) {
        if (null == cellDescriptors) {
            throw new IllegalArgumentException("Cell descriptors cannot be null");
        }
        if (null == sheet) {
            throw new IllegalArgumentException("Sheet cannot be null");
        }
        if (null == clazz) {
            throw new IllegalArgumentException("Clazz cannot be null");
        }
        this.cellDescriptors = cellDescriptors;
        this.sheet = sheet;
        this.clazz = clazz;
    }

    public Set<CellDescriptor> getCellDescriptors() {
        return this.cellDescriptors;
    }

    protected List<T> readSheet() throws PoiParserException {
        try {
            Iterator rowIterator;
            ArrayList<T> dimensionList = new ArrayList<T>();
            if (null != this.getSheet() && (rowIterator = this.sheet.rowIterator()).hasNext()) {
                if (this.ignoreFirstRow) {
                    rowIterator.next();
                }
                while (rowIterator.hasNext()) {
                    Row row = (Row)rowIterator.next();
                    if (this.ignoreRow(row)) continue;
                    T rowObject = this.readRow(this.sheet.getSheetName(), row, this.clazz.newInstance());
                    dimensionList.add(rowObject);
                }
            }
            return dimensionList;
        }
        catch (InstantiationException e) {
            throw new PoiParserException("Error while creating instance of clazz", e);
        }
        catch (IllegalAccessException e) {
            throw new PoiParserException("Error while accessing clazz", e);
        }
    }

    protected List<T> readSheet(int startRow, int endRow) throws PoiParserException {
        try {
            ArrayList<T> dimensionList = new ArrayList<T>();
            if (null != this.sheet) {
                for (int i = startRow; i <= endRow; ++i) {
                    Row row = this.sheet.getRow(i);
                    if (this.ignoreRow(row)) continue;
                    T rowObject = this.readRow(this.sheet.getSheetName(), row, this.clazz.newInstance());
                    dimensionList.add(rowObject);
                }
            }
            return dimensionList;
        }
        catch (InstantiationException e) {
            throw new PoiParserException("Error while creating instance of clazz", e);
        }
        catch (IllegalAccessException e) {
            throw new PoiParserException("Error while accessing clazz", e);
        }
    }

    public boolean ignoreRow(Row row) {
        return this.isEmptyRow(row);
    }

    public boolean isEmptyRow(Row row) {
        if (null != row) {
            for (CellDescriptor cellDescriptor : this.getCellDescriptors()) {
                Integer columnNumber = cellDescriptor.getColumnNumber();
                if (this.isEmptyValue(row.getCell(columnNumber.intValue(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEmptyValue(Cell cell) {
        return null == cell;
    }

    protected T readRow(String sheetName, Row row, T rowDimension) throws PoiParserException {
        if (null != row) {
            log.debug((Object)("Read row with number: " + row.getRowNum()));
            for (CellDescriptor cellDescriptor : this.getCellDescriptors()) {
                this.readField(sheetName, row, rowDimension, cellDescriptor);
            }
        }
        return rowDimension;
    }

    protected void readField(String sheetName, Row row, T rowDimension, CellDescriptor cellDescriptor) throws PoiParserException {
        try {
            if (cellDescriptor.isReadIgnore()) {
                return;
            }
            Cell cell = row.getCell(cellDescriptor.getColumnNumber(), Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (null != cell) {
                log.trace((Object)("Reading field " + cellDescriptor.getFieldName() + " on row " + row.getRowNum() + " that is mapped on column " + cellDescriptor.getColumnNumber() + " with value: " + cell.toString()));
                Converter<?> converter = this.converterFactory.getConverter(cellDescriptor.getType());
                if (null != converter) {
                    try {
                        this.populateDimensionAsField(rowDimension, cellDescriptor.getFieldName(), converter, cell);
                    }
                    catch (PoiParserException e) {
                        this.populateDimensionAsProperty(rowDimension, cellDescriptor.getFieldName(), converter, cell);
                    }
                }
            } else {
                log.trace((Object)("Reading field " + cellDescriptor.getFieldName() + " on row " + row.getRowNum() + " that is mapped on column " + cellDescriptor.getColumnNumber() + " is empty."));
                if (cellDescriptor.isRequired()) {
                    throw new RequiredFieldPoiParserException(sheetName, row.getRowNum(), cellDescriptor.getColumnNumber());
                }
            }
        }
        catch (PoiParserException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw new PoiParserException("Error while setting field/property", e);
        }
        catch (IllegalAccessException e) {
            throw new PoiParserException("Error while setting field/property", e);
        }
    }

    private void populateDimensionAsField(T rowDimension, String fieldName, Converter<T> converter, Cell cell) throws PoiParserException {
        try {
            rowDimension.getClass().getDeclaredField(fieldName).setAccessible(true);
            Field field = rowDimension.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(rowDimension, converter.readCell(cell));
            field.setAccessible(false);
        }
        catch (IllegalAccessException e) {
            throw new PoiParserException("Unable set field " + fieldName, e);
        }
        catch (NoSuchFieldException e) {
            throw new PoiParserException("Unable set field " + fieldName, e);
        }
    }

    private void populateDimensionAsProperty(T rowDimension, String propertyName, Converter<T> converter, Cell cell) throws PoiParserException {
        try {
            this.createRequiredUnderlyingInstancesForNestedProperties(rowDimension, propertyName);
            PropertyUtils.setNestedProperty(rowDimension, (String)propertyName, converter.readCell(cell));
        }
        catch (IllegalAccessException e) {
            throw new PoiParserException("Unable set property " + propertyName, e);
        }
        catch (InvocationTargetException e) {
            throw new PoiParserException("Unable set property " + propertyName, e);
        }
        catch (NoSuchMethodException e) {
            throw new PoiParserException("Unable set property " + propertyName, e);
        }
    }

    private void createRequiredUnderlyingInstancesForNestedProperties(T rowDimension, String fieldName) {
        String[] propertyNames;
        String concatName = null;
        for (String createdInstanceName : propertyNames = fieldName.split("\\.")) {
            if (fieldName.endsWith(createdInstanceName)) {
                return;
            }
            concatName = null == concatName ? createdInstanceName : concatName + "." + createdInstanceName;
            try {
                if (null != PropertyUtils.getProperty(rowDimension, (String)concatName)) continue;
                Object x = PropertyUtils.getPropertyDescriptor(rowDimension, (String)concatName).getPropertyType().newInstance();
                PropertyUtils.setNestedProperty(rowDimension, (String)concatName, x);
            }
            catch (IllegalAccessException e) {
                log.trace((Object)"Error creating underlying instance", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.trace((Object)"Error creating underlying instance", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.trace((Object)"Error creating underlying instance", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.trace((Object)"Error creating underlying instance", (Throwable)e);
            }
        }
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setIgnoreFirstRow(boolean ignoreFirstRow) {
        this.ignoreFirstRow = ignoreFirstRow;
    }
}

