/*
 * Decompiled with CFR 0.152.
 */
package nl.bstoi.poiparser.core.strategy;

import java.util.Properties;

public class ColumnHeaderProperties {
    private final Properties properties;
    public static final String DOT = ".";

    public ColumnHeaderProperties(Properties properties) {
        if (null == properties) {
            throw new IllegalArgumentException("Properties cannot be null.");
        }
        this.properties = properties;
    }

    public void addColumnHeader(String sheetName, String propertyName, String value) {
        this.properties.setProperty(this.getColumnHeaderKey(sheetName, propertyName), value);
    }

    private String getColumnHeaderKey(String sheetName, String propertyName) {
        return sheetName + DOT + propertyName;
    }

    public String getColumnHeader(String sheetName, String propertyName) {
        return this.properties.getProperty(this.getColumnHeaderKey(sheetName, propertyName));
    }

    public boolean containsColumnHeader(String sheetName, String propertyName) {
        return this.properties.containsKey(this.getColumnHeaderKey(sheetName, propertyName));
    }
}

