/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.ImageAtlas;
import nl.colorize.multimedialib.math.Rect;

public class BitmapFont {
    private ImageAtlas imageAtlas;
    private int baseline;
    private int lineHeight;
    private int letterSpacing;
    private static final float DEFAULT_BASELINE_FACTOR = 0.75f;
    private static final float DEFAULT_LINE_HEIGHT_FACTOR = 1.5f;
    private static final int DEFAULT_LETTER_SPACING = 0;
    private static final String GLYPH_NOT_FOUND = "?";

    public BitmapFont(ImageAtlas imageAtlas) {
        this.imageAtlas = imageAtlas;
        Rect typicalGlyph = imageAtlas.getSubImageBounds("a");
        this.baseline = Math.round(0.75f * (float)typicalGlyph.getHeight());
        this.lineHeight = Math.round(1.5f * (float)typicalGlyph.getHeight());
        this.letterSpacing = 0;
        this.getGlyph(GLYPH_NOT_FOUND.charAt(0));
    }

    public int getBaseline() {
        return this.baseline;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getLetterSpacing() {
        return this.letterSpacing;
    }

    public ImageAtlas getImageAtlas() {
        return this.imageAtlas;
    }

    private String toGlyphName(char c) {
        String glyph = Character.toString(c);
        if (this.imageAtlas.containsSubImage(glyph)) {
            return glyph;
        }
        return GLYPH_NOT_FOUND;
    }

    public Image getGlyph(char c) {
        return this.imageAtlas.getSubImage(this.toGlyphName(c));
    }

    public Rect getGlyphBounds(char c) {
        return this.imageAtlas.getSubImageBounds(this.toGlyphName(c));
    }
}

