/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import nl.colorize.multimedialib.graphics.BitmapFont;
import nl.colorize.multimedialib.graphics.ImageAtlas;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.xml.XMLHelper;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImageAtlasLoader {
    private MediaLoader mediaLoader;

    public ImageAtlasLoader(MediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
    }

    public ImageAtlas load(ResourceFile imageSource, ResourceFile xmlSource) {
        ImageAtlas imageAtlas = new ImageAtlas(this.mediaLoader.loadImage(imageSource));
        try {
            Document xml = XMLHelper.parse((ResourceFile)xmlSource);
            this.parseImageAtlasXML(xml, imageAtlas);
        }
        catch (JDOMException e) {
            throw new RendererException("Cannot parse image atlas XML file: " + xmlSource, e);
        }
        return imageAtlas;
    }

    private void parseImageAtlasXML(Document xml, ImageAtlas imageAtlas) {
        Element imageAtlasElement = xml.getRootElement();
        if (!imageAtlasElement.getName().equals("imageAtlas")) {
            throw new RendererException("XML file does not appear to contain image atlas");
        }
        for (Element subImageElement : imageAtlasElement.getChildren("subImage")) {
            String name = subImageElement.getAttributeValue("name");
            Rect region = this.parseRegionElement(subImageElement.getChild("region"));
            imageAtlas.markSubImage(name, region);
        }
    }

    private Rect parseRegionElement(Element child) {
        int x = Integer.parseInt(child.getAttributeValue("x"));
        int y = Integer.parseInt(child.getAttributeValue("y"));
        int width = Integer.parseInt(child.getAttributeValue("width"));
        int height = Integer.parseInt(child.getAttributeValue("height"));
        return new Rect(x, y, width, height);
    }

    public Document export(ImageAtlas imageAtlas) {
        Element imageAtlasElement = new Element("imageAtlas");
        for (String name : imageAtlas.getSubImages().keySet()) {
            imageAtlasElement.addContent((Content)this.buildSubImageElement(imageAtlas, name));
        }
        return new Document(imageAtlasElement);
    }

    private Element buildSubImageElement(ImageAtlas imageAtlas, String name) {
        Rect region = imageAtlas.getSubImageBounds(name);
        Element subImageElement = new Element("subImage");
        subImageElement.setAttribute("name", name);
        subImageElement.addContent((Content)this.buildBoundsElement("region", region));
        return subImageElement;
    }

    private Element buildBoundsElement(String name, Rect bounds) {
        Element boundsElement = new Element(name);
        boundsElement.setAttribute("x", String.valueOf(bounds.getX()));
        boundsElement.setAttribute("y", String.valueOf(bounds.getY()));
        boundsElement.setAttribute("width", String.valueOf(bounds.getWidth()));
        boundsElement.setAttribute("height", String.valueOf(bounds.getHeight()));
        return boundsElement;
    }

    public BitmapFont loadBitmapFont(ResourceFile imageSource, ResourceFile xmlSource) {
        ImageAtlas imageAtlas = this.load(imageSource, xmlSource);
        return new BitmapFont(imageAtlas);
    }

    public Document exportBitmapFont(BitmapFont font) {
        return this.export(font.getImageAtlas());
    }
}

