/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.util.animation.Animatable;

public class Sprite
implements Animatable {
    private Map<String, Animation> availableStates = new HashMap<String, Animation>();
    private String currentState = null;
    private float timeInCurrentState = 0.0f;

    public void addState(String name, Animation stateGraphics, Shape boundingShape) {
        Preconditions.checkArgument((!this.availableStates.containsKey(name) ? 1 : 0) != 0, (Object)("Duplicate state: " + name));
        Preconditions.checkArgument((stateGraphics != null ? 1 : 0) != 0, (Object)("No graphics for state: " + name));
        this.availableStates.put(name, stateGraphics);
        if (this.currentState == null) {
            this.changeState(name);
        }
    }

    public void addState(String name, Image stateGraphics, Shape boundingShape) {
        this.addState(name, new Animation(stateGraphics), boundingShape);
    }

    public void addState(String name, Animation stateGraphics) {
        this.addState(name, stateGraphics, null);
    }

    public void addState(String name, Image stateGraphics) {
        this.addState(name, stateGraphics, null);
    }

    public void changeState(String name) {
        this.currentState = name;
        this.timeInCurrentState = 0.0f;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public Set<String> getAvailableStates() {
        return ImmutableSet.copyOf(this.availableStates.keySet());
    }

    public void onFrame(float deltaTime) {
        Preconditions.checkState((!this.availableStates.isEmpty() ? 1 : 0) != 0, (Object)"Sprite does not have graphics yet");
        this.timeInCurrentState += deltaTime;
    }

    public Image getCurrentGraphics() {
        Preconditions.checkState((this.currentState != null ? 1 : 0) != 0, (Object)"Sprite does not have graphics yet");
        return this.availableStates.get(this.currentState).getFrameAtTime(this.timeInCurrentState);
    }
}

