/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.MathUtils;

public class Transform {
    private int rotation;
    private int scaleX;
    private int scaleY;
    private int alpha;

    public Transform() {
        this.reset();
    }

    public void reset() {
        this.rotation = 0;
        this.scaleX = 100;
        this.scaleY = 100;
        this.alpha = 100;
    }

    public boolean isDefaultTransform() {
        return !this.isRotated() && !this.isScaled() && this.alpha == 100;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation % (rotation >= 0 ? 360 : -360);
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getRotationInRadians() {
        return (float)Math.toRadians(this.rotation);
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setScale(int scaleX, int scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    public void setScaleX(int scaleX) {
        Preconditions.checkArgument((scaleX >= 1 ? 1 : 0) != 0, (Object)("Invalid scale: " + scaleX));
        this.scaleX = scaleX;
    }

    public int getScaleX() {
        return this.scaleX;
    }

    public void setScaleY(int scaleY) {
        Preconditions.checkArgument((scaleY >= 1 ? 1 : 0) != 0, (Object)("Invalid scale: " + scaleY));
        this.scaleY = scaleY;
    }

    public int getScaleY() {
        return this.scaleY;
    }

    public boolean isScaled() {
        return this.scaleX != 100 || this.scaleY != 100;
    }

    public void setAlpha(int alpha) {
        this.alpha = MathUtils.clamp(alpha, 0, 100);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean equals(Object o) {
        if (o instanceof Transform) {
            Transform other = (Transform)o;
            return this.rotation == other.rotation && this.scaleX == other.scaleX && this.scaleY == other.scaleY && this.alpha == other.alpha;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rotation, this.scaleX, this.scaleY, this.alpha});
    }

    public String toString() {
        return String.format("Transform(rotation=%d, scale=%d/%d, alpha=%d)", this.rotation, this.scaleX, this.scaleY, this.alpha);
    }
}

