/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.math.IntMath;
import java.util.Collection;
import nl.colorize.multimedialib.math.Rect;

public final class MathUtils {
    private static final float EPSILON = 0.001f;

    private MathUtils() {
    }

    public static int ceiling(float n) {
        int truncated = (int)n;
        float remainder = n - (float)truncated;
        return remainder >= 0.001f ? truncated + 1 : truncated;
    }

    public static int signum(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static int signum(float n) {
        if (n > 0.0f) {
            return 1;
        }
        if (n < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static int sum(int[] values) {
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        return sum;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static float average(Collection<? extends Number> numbers) {
        float sum = 0.0f;
        for (Number number : numbers) {
            sum += number.floatValue();
        }
        return sum / (float)numbers.size();
    }

    public static boolean isPowerOfTwo(int n) {
        return IntMath.isPowerOfTwo((int)n);
    }

    public static int nextPowerOfTwo(int n) {
        if (MathUtils.isPowerOfTwo(n)) {
            return n;
        }
        for (int i = 4; i < 32768; i *= 2) {
            if (i <= n) continue;
            return i;
        }
        throw new IllegalArgumentException("Number out of range");
    }

    public static float getAspectRatio(int width, int height) {
        if (width == 0 || height == 0) {
            return 1.0f;
        }
        return (float)width / (float)height;
    }

    public static float getAspectRatio(Rect r) {
        return MathUtils.getAspectRatio(r.getWidth(), r.getHeight());
    }
}

