/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.Objects;

public class Point2D {
    private float x;
    private float y;
    public static final float EPSILON = 0.001f;

    public Point2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public float calculateDistance(Point2D other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float calculateAngle(Point2D other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        float deltaX = other.x - this.x;
        float deltaY = other.y - this.y;
        return (float)Math.toDegrees(Math.atan2(deltaY, deltaX));
    }

    public boolean equals(Object o) {
        if (o instanceof Point2D) {
            Point2D other = (Point2D)o;
            return Math.abs(this.x - other.x) < 0.001f && Math.abs(this.y - other.y) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return String.format("(%.1f, %.1f)", Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

