/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.Arrays;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Shape;

public class Polygon
implements Shape {
    private int[] points;

    public Polygon(int[] points) {
        this.setPoints(points);
    }

    private void checkPoints(int[] points) {
        if (points.length < 3) {
            throw new IllegalArgumentException("Convex polygon must have at least 3 points");
        }
        if (points.length % 2 == 1) {
            throw new IllegalArgumentException("Invalid points: " + Arrays.toString(points));
        }
    }

    public void setPoints(int[] points) {
        this.checkPoints(points);
        this.points = points;
    }

    public int[] getPoints() {
        return this.points;
    }

    public int getNumPoints() {
        return this.points.length / 2;
    }

    public int getPointX(int n) {
        return this.points[2 * n];
    }

    public int getPointY(int n) {
        return this.points[2 * n + 1];
    }

    public void move(int dx, int dy) {
        for (int i = 0; i < this.points.length; i += 2) {
            int n = i;
            this.points[n] = this.points[n] + dx;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + dy;
        }
    }

    public void rotateDegrees(int degrees, int ox, int oy) {
        if (degrees != 0) {
            this.rotateRadians(Math.toRadians(degrees), ox, oy);
        }
    }

    public void rotateRadians(double radians, int ox, int oy) {
        for (int i = 0; i < this.points.length; i += 2) {
            int x0 = this.points[i];
            int y0 = this.points[i + 1];
            double x = Math.cos(radians) * (double)(x0 - ox) - Math.sin(radians) * (double)(y0 - oy) + (double)ox;
            double y = Math.sin(radians) * (double)(x0 - ox) + Math.cos(radians) * (double)(y0 - oy) + (double)oy;
            this.points[i] = (int)Math.round(x);
            this.points[i + 1] = (int)Math.round(y);
        }
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains((int)p.getX(), (int)p.getY());
    }

    @Override
    public boolean contains(int px, int py) {
        return this.isPointInPolygon(px, py) || this.isPointOnLineSegment(px, py);
    }

    private boolean isPointInPolygon(int px, int py) {
        boolean oddNodes = false;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = this.points[this.points.length - 2];
        float y2 = this.points[this.points.length - 1];
        for (int i = 0; i < this.points.length; i += 2) {
            x1 = this.points[i];
            y1 = this.points[i + 1];
            if ((y1 < (float)py && y2 >= (float)py || y1 >= (float)py && y2 < (float)py) && ((float)py - y1) / (y2 - y1) * (x2 - x1) < (float)px - x1) {
                oddNodes = !oddNodes;
            }
            x2 = x1;
            y2 = y1;
        }
        return oddNodes;
    }

    private boolean isPointOnLineSegment(int px, int py) {
        for (int i = 0; i < this.points.length - 2; i += 2) {
            if (!this.isPointOnLineSegment(this.points[i], this.points[i + 1], this.points[i + 2], this.points[i + 3], px, py)) continue;
            return true;
        }
        return this.isPointOnLineSegment(this.points[this.points.length - 2], this.points[this.points.length - 1], this.points[0], this.points[1], px, py);
    }

    private boolean isPointOnLineSegment(int x0, int y0, int x1, int y1, int px, int py) {
        int crossproduct = (py - y0) * (x1 - x0) - (px - x0) * (y1 - y0);
        if (crossproduct != 0) {
            return false;
        }
        int dotproduct = (px - x0) * (x1 - x0) + (py - y0) * (x1 - y0);
        if (dotproduct < 0) {
            return false;
        }
        int squaredLength = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
        return dotproduct <= squaredLength;
    }

    @Override
    public boolean contains(Shape s) {
        int[] pPoints = s.toPolygon().getPoints();
        for (int i = 0; i < pPoints.length; i += 2) {
            if (this.contains(pPoints[i], pPoints[i + 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(Shape s) {
        Polygon p = s.toPolygon();
        return this.contains(p) || p.contains(this) || this.checkPolygonIntersects(p);
    }

    private boolean checkPolygonIntersects(Polygon p) {
        int[] pPoints = p.getPoints();
        for (int i = 0; i < this.points.length; i += 2) {
            int iNext = i + 2;
            if (iNext >= this.points.length) {
                iNext = 0;
            }
            for (int j = 0; j < pPoints.length; j += 2) {
                int jNext = j + 2;
                if (jNext >= pPoints.length) {
                    jNext = 0;
                }
                double unknownA = ((double)(this.points[iNext] - this.points[i]) * (double)(pPoints[j + 1] - this.points[i + 1]) - (double)((this.points[iNext + 1] - this.points[i + 1]) * (pPoints[j] - this.points[i]))) / (double)((this.points[iNext + 1] - this.points[i + 1]) * (pPoints[jNext] - pPoints[j]) - (this.points[iNext] - this.points[i]) * (pPoints[jNext + 1] - pPoints[j + 1]));
                double unknownB = ((double)(pPoints[jNext] - pPoints[j]) * (double)(pPoints[j + 1] - this.points[i + 1]) - (double)((pPoints[jNext + 1] - pPoints[j + 1]) * (pPoints[j] - this.points[i]))) / (double)((this.points[iNext + 1] - this.points[i + 1]) * (pPoints[jNext] - pPoints[j]) - (this.points[iNext] - this.points[i]) * (pPoints[jNext + 1] - pPoints[j + 1]));
                if (!(unknownA >= 0.0) || !(unknownA <= 1.0) || !(unknownB >= 0.0) || !(unknownB <= 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Polygon toPolygon() {
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof Polygon) {
            Polygon other = (Polygon)o;
            return Arrays.equals(this.points, other.points);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.points);
    }

    public String toString() {
        return Arrays.toString(this.points);
    }
}

