/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.List;
import java.util.Random;

public final class Rand {
    private static final Random RANDOM = new Random();

    private Rand() {
    }

    public static int nextInt(int upper) {
        return Rand.nextInt(0, upper);
    }

    public static int nextInt(int lower, int upper) {
        int range = upper - lower;
        return RANDOM.nextInt(range) + lower;
    }

    public static float nextFloat() {
        return RANDOM.nextFloat();
    }

    public static float nextFloat(float lower, float upper) {
        float range = upper - lower;
        return RANDOM.nextFloat() * range + lower;
    }

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }

    public static boolean chance(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Argument out of range 0..1: " + f);
        }
        return f > RANDOM.nextFloat();
    }

    public static <E> E oneFrom(List<E> elements) {
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("List empty");
        }
        int index = Rand.nextInt(0, elements.size());
        return elements.get(index);
    }

    public static <E> E oneFrom(E[] elements) {
        if (elements.length == 0) {
            throw new IllegalArgumentException("array empty");
        }
        int index = Rand.nextInt(0, elements.length);
        return elements[index];
    }
}

