/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Shape;

public class Rect
implements Shape {
    private int x;
    private int y;
    private int width;
    private int height;

    public Rect(int x, int y, int width, int height) {
        this.set(x, y, width, height);
    }

    public void set(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getY() {
        return this.y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getEndX() {
        return this.x + this.width;
    }

    public int getEndY() {
        return this.y + this.height;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains((int)p.getX(), (int)p.getY());
    }

    @Override
    public boolean contains(int px, int py) {
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    @Override
    public boolean contains(Shape s) {
        if (s instanceof Rect) {
            Rect r = (Rect)s;
            return this.contains(r.x, r.y, r.width, r.height);
        }
        return s.toPolygon().intersects(this);
    }

    public boolean contains(int rx, int ry, int rwidth, int rheight) {
        return rx >= this.x && rx + rwidth <= this.x + this.width && ry >= this.y && ry + rheight <= this.y + this.height;
    }

    @Override
    public boolean intersects(Shape s) {
        if (s instanceof Rect) {
            Rect r = (Rect)s;
            return this.intersects(r.x, r.y, r.width, r.height);
        }
        return s.toPolygon().intersects(this);
    }

    public boolean intersects(int rx, int ry, int rwidth, int rheight) {
        return rx + rwidth >= this.x && rx <= this.x + this.width && ry + rheight >= this.y && ry <= this.y + this.height;
    }

    @Override
    public Polygon toPolygon() {
        int[] points = new int[]{this.x, this.y, this.x + this.width, this.y, this.x + this.width, this.y + this.height, this.x, this.y + this.height};
        return new Polygon(points);
    }

    public boolean equals(Object o) {
        if (o instanceof Rect) {
            Rect r = (Rect)o;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return false;
    }

    public int hashCode() {
        return this.x * 1000000 + this.y * 10000 + this.width * 100 + this.height;
    }

    public String toString() {
        return String.format("[%d, %d, %d, %d]", this.x, this.y, this.width, this.height);
    }
}

