/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.BitmapFont;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.RenderContext;
import nl.colorize.multimedialib.renderer.RenderStats;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Stopwatch;

public abstract class AnimationLoopRenderer
implements Renderer,
RenderContext {
    protected ScaleStrategy scaling;
    protected int framerate;
    private List<RenderCallback> callbacks;
    private RenderStats stats;
    private Stopwatch timer;
    private float accumulatedTime;
    private static final Logger LOGGER = LogHelper.getLogger(AnimationLoopRenderer.class, (Handler[])new Handler[0]);

    public AnimationLoopRenderer(ScaleStrategy scaling, int framerate) {
        Preconditions.checkArgument((framerate >= 1 ? 1 : 0) != 0, (Object)("Invalid framerate: " + framerate));
        this.scaling = scaling;
        this.framerate = framerate;
        this.callbacks = new ArrayList<RenderCallback>();
        this.stats = new RenderStats();
        this.registerCallback(this.stats);
    }

    protected void performFrameUpdate() {
        if (this.timer == null) {
            this.timer = new Stopwatch();
            this.accumulatedTime = 0.0f;
        }
        float frameTime = this.getFrameTime();
        float deltaTime = (float)this.timer.tick() / 1000.0f;
        for (RenderCallback callback : this.callbacks) {
            callback.onFrame(frameTime, this.getInputDevice());
        }
        for (RenderCallback callback : this.callbacks) {
            callback.onRender(this);
        }
        this.syncFrames(frameTime);
    }

    private void syncFrames(float frameTime) {
        if (this.shouldSyncFrames()) {
            float sleepTime = frameTime - (float)this.timer.tock() / 1000.0f;
            long sleepTimeInMilliseconds = Math.round(sleepTime * 1000.0f);
            sleepTimeInMilliseconds = Math.max(sleepTimeInMilliseconds, 1L);
            try {
                Thread.sleep(sleepTimeInMilliseconds);
            }
            catch (InterruptedException e) {
                LOGGER.warning("Frame sync interrupted");
            }
        }
    }

    protected abstract boolean shouldSyncFrames();

    @Override
    public int getCanvasWidth() {
        return this.scaling.getCanvasWidth(this.getScreenBounds());
    }

    @Override
    public int getCanvasHeight() {
        return this.scaling.getCanvasHeight(this.getScreenBounds());
    }

    protected abstract Rect getScreenBounds();

    @Override
    public void drawText(String text, BitmapFont font, int x, int y) {
        int currentX = x;
        int currentY = y - font.getBaseline();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            Image glyph = font.getGlyph(c);
            Rect glyphBounds = font.getGlyphBounds(c);
            this.drawImage(glyph, currentX + glyphBounds.getWidth() / 2, currentY + glyphBounds.getHeight() / 2, null);
            currentX += glyphBounds.getWidth() + font.getLetterSpacing();
        }
    }

    @Override
    public ScaleStrategy getScaleStrategy() {
        return this.scaling;
    }

    @Override
    public int getTargetFramerate() {
        return this.framerate;
    }

    public float getFrameTime() {
        return 1.0f / (float)this.framerate;
    }

    protected abstract InputDevice getInputDevice();

    @Override
    public RenderStats getStats() {
        return this.stats;
    }

    @Override
    public void registerCallback(RenderCallback callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void unregisterCallback(RenderCallback callback) {
        this.callbacks.remove(callback);
    }
}

