/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.RenderContext;
import nl.colorize.util.Stopwatch;

public class RenderStats
implements RenderCallback {
    private Stopwatch fpsTimer = new Stopwatch();
    private float[] fpsSamples = new float[100];
    private int fpsSampleIndex = 0;
    private Stopwatch upsTimer = new Stopwatch();
    private float[] upsSamples = new float[100];
    private int upsSampleIndex = 0;
    private static final int NUM_SAMPLES = 100;
    private static final float EPSILON = 0.001f;

    @Override
    public void onFrame(float deltaTime, InputDevice input) {
        this.upsSamples[this.upsSampleIndex] = (float)this.upsTimer.tick() / 1000.0f;
        this.upsSampleIndex = (this.upsSampleIndex + 1) % 100;
    }

    @Override
    public void onRender(RenderContext context) {
        this.fpsSamples[this.fpsSampleIndex] = (float)this.fpsTimer.tick() / 1000.0f;
        this.fpsSampleIndex = (this.fpsSampleIndex + 1) % 100;
    }

    public float getAverageFPS() {
        return 1.0f / this.calculateAverage(this.fpsSamples);
    }

    public float getAverageUPS() {
        return 1.0f / this.calculateAverage(this.upsSamples);
    }

    private float calculateAverage(float[] values) {
        float total = 0.0f;
        int count = 0;
        for (float value : values) {
            if (!(value >= 0.001f)) continue;
            total += value;
            ++count;
        }
        if (count > 0) {
            return total / (float)count;
        }
        return 0.0f;
    }
}

