/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Rect;

public class ScaleStrategy {
    private int canvasWidth;
    private int canvasHeight;
    private boolean flexible;
    private boolean proportional;

    private ScaleStrategy(int canvasWidth, int canvasHeight, boolean flexible, boolean proportional) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.flexible = flexible;
        this.proportional = proportional;
    }

    public int getCanvasWidth(Rect screen) {
        return this.flexible ? screen.getWidth() : this.canvasWidth;
    }

    public int getCanvasHeight(Rect screen) {
        return this.flexible ? screen.getHeight() : this.canvasHeight;
    }

    public Rect getPreferredCanvasBounds() {
        return new Rect(0, 0, this.canvasWidth, this.canvasHeight);
    }

    public Rect getCanvasBounds(Rect screen) {
        if (this.flexible) {
            return screen;
        }
        int canvasX = this.getScaledCanvasX(screen);
        int canvasY = this.getScaledCanvasY(screen);
        int scaledCanvasWidth = this.getScaledCanvasWidth(screen);
        int scaledCanvasHeight = this.getScaledCanvasHeight(screen);
        return new Rect(canvasX, canvasY, scaledCanvasWidth, scaledCanvasHeight);
    }

    private int getScaledCanvasX(Rect screen) {
        if (this.flexible) {
            return screen.getX();
        }
        return (screen.getWidth() - this.getScaledCanvasWidth(screen)) / 2 + screen.getX();
    }

    private int getScaledCanvasY(Rect screen) {
        if (this.flexible) {
            return screen.getY();
        }
        return (screen.getHeight() - this.getScaledCanvasHeight(screen)) / 2 + screen.getY();
    }

    int getScaledCanvasWidth(Rect screen) {
        if (this.flexible) {
            return screen.getWidth();
        }
        return Math.round((float)this.canvasWidth * this.getScaleFactorX(screen));
    }

    int getScaledCanvasHeight(Rect screen) {
        if (this.flexible) {
            return screen.getHeight();
        }
        return Math.round((float)this.canvasHeight * this.getScaleFactorY(screen));
    }

    public float getScaleFactorX(Rect screen) {
        float screenAspectRatio;
        float canvasAspectRatio;
        if (this.flexible) {
            return 1.0f;
        }
        int scaledCanvasWidth = screen.getWidth();
        if (this.proportional && (canvasAspectRatio = MathUtils.getAspectRatio(this.canvasWidth, this.canvasHeight)) < (screenAspectRatio = MathUtils.getAspectRatio(screen))) {
            scaledCanvasWidth = Math.round((float)screen.getHeight() * canvasAspectRatio);
        }
        return (float)scaledCanvasWidth / (float)this.canvasWidth;
    }

    public float getScaleFactorY(Rect screen) {
        float screenAspectRatio;
        float canvasAspectRatio;
        if (this.flexible) {
            return 1.0f;
        }
        int scaledCanvasHeight = screen.getHeight();
        if (this.proportional && (canvasAspectRatio = MathUtils.getAspectRatio(this.canvasWidth, this.canvasHeight)) >= (screenAspectRatio = MathUtils.getAspectRatio(screen))) {
            scaledCanvasHeight = Math.round((float)screen.getWidth() * (1.0f / canvasAspectRatio));
        }
        return (float)scaledCanvasHeight / (float)this.canvasHeight;
    }

    public int convertToScreenX(Rect screen, int canvasX) {
        float scaleFactor = this.getScaleFactorX(screen);
        int offset = this.getScaledCanvasX(screen);
        return Math.round((float)canvasX * scaleFactor + (float)offset);
    }

    public int convertToScreenY(Rect screen, int canvasY) {
        float scaleFactor = this.getScaleFactorY(screen);
        int offset = this.getScaledCanvasY(screen);
        return Math.round((float)canvasY * scaleFactor + (float)offset);
    }

    public int convertToCanvasX(Rect screen, int screenX) {
        float scaleFactor = this.getScaleFactorX(screen);
        int offset = this.getScaledCanvasX(screen);
        return Math.round((float)(screenX - offset) / scaleFactor);
    }

    public int convertToCanvasY(Rect screen, int screenY) {
        float scaleFactor = this.getScaleFactorY(screen);
        int offset = this.getScaledCanvasY(screen);
        return Math.round((float)(screenY - offset) / scaleFactor);
    }

    public static ScaleStrategy flexible(int initialCanvasWidth, int initialCanvasHeight) {
        return new ScaleStrategy(initialCanvasWidth, initialCanvasHeight, true, false);
    }

    public static ScaleStrategy fixed(int canvasWidth, int canvasHeight) {
        return new ScaleStrategy(canvasWidth, canvasHeight, false, false){

            @Override
            public float getScaleFactorX(Rect screen) {
                return 1.0f;
            }

            @Override
            public float getScaleFactorY(Rect screen) {
                return 1.0f;
            }
        };
    }

    public static ScaleStrategy stretch(int canvasWidth, int canvasHeight) {
        return new ScaleStrategy(canvasWidth, canvasHeight, false, false);
    }

    public static ScaleStrategy proportional(int canvasWidth, int canvasHeight) {
        return new ScaleStrategy(canvasWidth, canvasHeight, false, true);
    }

    public static ScaleStrategy smart(int canvasWidth, int canvasHeight) {
        return new ScaleStrategy(canvasWidth, canvasHeight, false, true){

            @Override
            public int getCanvasWidth(Rect screen) {
                float screenAspectRatio = MathUtils.getAspectRatio(screen);
                return Math.round((float)this.getCanvasHeight(screen) * screenAspectRatio);
            }

            @Override
            int getScaledCanvasWidth(Rect screen) {
                return screen.getWidth();
            }

            @Override
            int getScaledCanvasHeight(Rect screen) {
                return screen.getHeight();
            }
        };
    }
}

