/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;

public class AWTInput
implements InputDevice,
KeyListener,
MouseListener,
MouseMotionListener {
    private Java2DRenderer renderer;
    private List<InputEvent> eventsBuffer;
    private int[] keyStates;
    private int mouseX;
    private int mouseY;
    private int mouseState;
    private static final int KEY_STATE_DEFAULT = 0;
    private static final int KEY_STATE_PRESSED = 1;
    private static final int KEY_STATE_RELEASED = 2;
    private static final int MOUSE_STATE_DEFAULT = 0;
    private static final int MOUSE_STATE_PRESSED = 1;
    private static final int MOUSE_STATE_RELEASED = 2;
    private static final int MAX_KEY_CODES = 600;

    public AWTInput(Java2DRenderer renderer) {
        this.renderer = renderer;
        this.eventsBuffer = Collections.synchronizedList(new ArrayList());
        this.keyStates = new int[600];
        this.mouseX = 0;
        this.mouseY = 0;
        this.mouseState = 0;
    }

    public void refreshFromEventBuffer() {
        InputEvent[] bufferSnapshot = this.eventsBuffer.toArray(new InputEvent[0]);
        this.eventsBuffer.clear();
        this.resetState();
        for (InputEvent event : bufferSnapshot) {
            if (event instanceof KeyEvent) {
                this.handleKeyEvent((KeyEvent)event);
                continue;
            }
            if (!(event instanceof MouseEvent)) continue;
            this.handleMouseEvent((MouseEvent)event);
        }
    }

    private void resetState() {
        for (int i = 0; i < 600; ++i) {
            if (this.keyStates[i] != 2) continue;
            this.keyStates[i] = 0;
        }
        if (this.mouseState == 2) {
            this.mouseState = 0;
        }
    }

    private void handleKeyEvent(KeyEvent event) {
        int eventID = event.getID();
        if (eventID == 401) {
            this.setKeyState(event.getKeyCode(), 1);
        } else if (eventID == 402) {
            this.setKeyState(event.getKeyCode(), 2);
        }
    }

    private void handleMouseEvent(MouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        int eventID = event.getID();
        if (eventID == 501) {
            this.mouseState = 1;
        } else if (eventID == 502) {
            this.mouseState = 2;
        }
    }

    private void setKeyState(int keycode, int state) {
        if (keycode >= 0 && keycode < 600) {
            this.keyStates[keycode] = state;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.eventsBuffer.add(e);
        e.consume();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
    }

    @Override
    public Point2D getPointer() {
        Rect screenBounds = this.renderer.getScreenBounds();
        int pointerOnCanvasX = this.renderer.getScaleStrategy().convertToCanvasX(screenBounds, this.mouseX);
        int pointerOnCanvasY = this.renderer.getScaleStrategy().convertToCanvasY(screenBounds, this.mouseY);
        return new Point2D(pointerOnCanvasX, pointerOnCanvasY);
    }

    @Override
    public boolean isPointerPressed() {
        return this.mouseState == 1;
    }

    @Override
    public boolean isPointerReleased() {
        return this.mouseState == 2;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return true;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return false;
    }

    public boolean isKeyPressed(int keycode) {
        return this.keyStates[keycode] == 1;
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return false;
    }

    public boolean isKeyReleased(int keycode) {
        return this.keyStates[keycode] == 2;
    }
}

