/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Preconditions;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.AnimationLoopRenderer;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.java2d.AWTInput;
import nl.colorize.multimedialib.renderer.java2d.Java2DImage;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.swing.SwingUtils;
import nl.colorize.util.swing.Utils2D;

public class Java2DRenderer
extends AnimationLoopRenderer {
    private AtomicBoolean active = new AtomicBoolean(false);
    private AWTInput inputDevice;
    private JFrame window;
    private Rect screenBounds;
    private AtomicBoolean layoutDirty;
    private Graphics2D graphicsContext;
    private BufferStrategy bufferStrategy;
    private AffineTransform transformHolder;
    private Color backgroundColor;
    private Map<ColorRGB, Color> colorCache;
    private String windowTitle;
    private BufferedImage windowIcon;
    private static final boolean ANTI_ALIASING = true;
    private static final boolean BILINEAR_SCALING = true;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private static final Logger LOGGER = LogHelper.getLogger(Java2DRenderer.class, (Handler[])new Handler[0]);

    public Java2DRenderer(ScaleStrategy scaling, int framerate) {
        super(scaling, framerate);
        this.screenBounds = scaling.getPreferredCanvasBounds();
        this.windowTitle = "";
        this.windowIcon = null;
        this.layoutDirty = new AtomicBoolean(true);
        this.transformHolder = new AffineTransform();
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.colorCache = new HashMap<ColorRGB, Color>();
    }

    @Override
    public void initialize() {
        Preconditions.checkState((!this.active.get() ? 1 : 0) != 0, (Object)"Renderer is already active");
        this.active.set(true);
        SwingUtils.initializeSwing();
        this.initializeWindow();
        this.reLayoutCanvas();
        this.inputDevice = new AWTInput(this);
        this.window.addKeyListener(this.inputDevice);
        this.window.addMouseListener(this.inputDevice);
        this.window.addMouseMotionListener(this.inputDevice);
        Thread renderingThread = new Thread(() -> this.runAnimationLoop(), "MultimediaLib-RenderingThread");
        renderingThread.start();
    }

    private void initializeWindow() {
        this.window = new JFrame();
        this.window.setDefaultCloseOperation(2);
        this.window.setResizable(true);
        this.window.setIgnoreRepaint(true);
        this.window.setFocusTraversalKeysEnabled(false);
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Java2DRenderer.this.layoutDirty.set(true);
            }
        });
        this.window.setLayout(new BorderLayout());
        this.window.add((Component)this.createCanvasPanel(), "Center");
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.onDisplayChanged();
        this.window.setVisible(true);
        this.window.createBufferStrategy(2);
    }

    private JPanel createCanvasPanel() {
        JPanel canvasPanel = new JPanel();
        canvasPanel.setPreferredSize(this.convertDimension(this.scaling.getPreferredCanvasBounds()));
        canvasPanel.setOpaque(false);
        canvasPanel.setFocusable(false);
        return canvasPanel;
    }

    private void onDisplayChanged() {
        if (this.window != null) {
            this.window.setTitle(this.windowTitle);
            this.window.setIconImage(this.windowIcon);
            this.reLayoutCanvas();
        }
    }

    private void reLayoutCanvas() {
        Insets windowInsets = this.window.getInsets();
        int windowWidth = this.window.getWidth() - windowInsets.left - windowInsets.right;
        int windowHeight = this.window.getHeight() - windowInsets.top - windowInsets.bottom;
        this.screenBounds = new Rect(windowInsets.left, windowInsets.top, windowWidth, windowHeight);
    }

    @Override
    public void terminate() {
        this.window.dispose();
    }

    private void runAnimationLoop() {
        while (this.active.get()) {
            this.prepareGraphicsContext();
            this.performFrameUpdate();
            this.blitGraphicsContext();
        }
    }

    private void prepareGraphicsContext() {
        if (this.window != null && this.layoutDirty.get()) {
            this.layoutDirty.set(false);
            this.reLayoutCanvas();
        }
        this.inputDevice.refreshFromEventBuffer();
        this.bufferStrategy = this.window.getBufferStrategy();
        Graphics bufferGraphics = this.bufferStrategy.getDrawGraphics();
        this.graphicsContext = Utils2D.createGraphics((Graphics)bufferGraphics, (boolean)true, (boolean)true);
        this.graphicsContext.setColor(this.backgroundColor);
        if (this.window != null) {
            this.graphicsContext.fillRect(0, 0, this.window.getWidth(), this.window.getHeight());
        } else {
            this.graphicsContext.fillRect(0, 0, this.screenBounds.getWidth(), this.screenBounds.getHeight());
        }
        this.clipToCanvas();
    }

    private void clipToCanvas() {
        int clipX = this.scaling.convertToScreenX(this.screenBounds, 0);
        int clipY = this.scaling.convertToScreenY(this.screenBounds, 0);
        int clipWidth = this.scaling.convertToScreenX(this.screenBounds, this.getCanvasWidth()) - clipX;
        int clipHeight = this.scaling.convertToScreenY(this.screenBounds, this.getCanvasHeight()) - clipY;
        this.graphicsContext.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    private void blitGraphicsContext() {
        this.graphicsContext.dispose();
        this.graphicsContext = null;
        if (!this.bufferStrategy.contentsLost()) {
            this.bufferStrategy.show();
            if (Platform.isLinux()) {
                this.window.getToolkit().sync();
            }
        }
        this.bufferStrategy = null;
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        this.backgroundColor = this.convertColor(backgroundColor);
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, Transform transform) {
        if (transform == null || !transform.isRotated() && !transform.isScaled()) {
            int screenX = this.scaling.convertToScreenX(this.screenBounds, rect.getCenterX());
            int screenY = this.scaling.convertToScreenY(this.screenBounds, rect.getCenterY());
            int screenWidth = (int)((float)rect.getWidth() * this.scaling.getScaleFactorX(this.screenBounds));
            int screenHeight = (int)((float)rect.getHeight() * this.scaling.getScaleFactorY(this.screenBounds));
            Composite originalComposite = this.graphicsContext.getComposite();
            this.applyAlphaCompositeForTransform(transform);
            this.graphicsContext.setColor(this.convertColor(color));
            this.graphicsContext.fillRect(screenX - screenWidth / 2, screenY - screenHeight / 2, screenWidth, screenHeight);
            this.graphicsContext.setComposite(originalComposite);
        } else {
            this.drawPolygon(rect.toPolygon(), color, transform);
        }
    }

    public void drawPolygon(Polygon polygon, ColorRGB color, Transform transform) {
        int[] px = new int[polygon.getNumPoints()];
        int[] py = new int[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            px[i] = this.scaling.convertToScreenX(this.screenBounds, polygon.getPointX(i));
            py[i] = this.scaling.convertToScreenY(this.screenBounds, polygon.getPointY(i));
        }
        Composite originalComposite = this.graphicsContext.getComposite();
        this.applyAlphaCompositeForTransform(transform);
        this.graphicsContext.setColor(this.convertColor(color));
        this.graphicsContext.fillPolygon(px, py, polygon.getNumPoints());
        this.graphicsContext.setComposite(originalComposite);
    }

    @Override
    public void drawImage(Image image, int x, int y, Transform transform) {
        this.drawImage(((Java2DImage)image).getImage(), x, y, transform);
    }

    private void drawImage(BufferedImage image, int x, int y, Transform transform) {
        int screenX = this.scaling.convertToScreenX(this.screenBounds, x);
        int screenY = this.scaling.convertToScreenY(this.screenBounds, y);
        float scaleX = this.scaling.getScaleFactorX(this.screenBounds);
        float scaleY = this.scaling.getScaleFactorY(this.screenBounds);
        int screenWidth = (int)((float)image.getWidth() * scaleX);
        int screenHeight = (int)((float)image.getHeight() * scaleY);
        if (this.isTransformed(transform)) {
            Composite originalComposite = this.graphicsContext.getComposite();
            this.applyAlphaCompositeForTransform(transform);
            this.transformHolder.setToIdentity();
            this.transformHolder.translate((float)screenX - (float)screenWidth / 2.0f, (float)screenY - (float)screenHeight / 2.0f);
            this.transformHolder.rotate(transform.getRotationInRadians(), (double)screenWidth / 2.0, (double)screenHeight / 2.0);
            this.transformHolder.scale(scaleX *= (float)transform.getScaleX() / 100.0f, scaleY *= (float)transform.getScaleY() / 100.0f);
            this.graphicsContext.drawImage(image, this.transformHolder, null);
            this.graphicsContext.setComposite(originalComposite);
        } else {
            this.graphicsContext.drawImage(image, screenX - screenWidth / 2, screenY - screenHeight / 2, screenWidth, screenHeight, null);
        }
    }

    private boolean isTransformed(Transform transform) {
        if (transform == null) {
            return false;
        }
        return transform.isRotated() || transform.isScaled() || transform.getAlpha() < 100;
    }

    private void applyAlphaCompositeForTransform(Transform transform) {
        if (transform != null && transform.getAlpha() != 100) {
            AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive((float)transform.getAlpha() / 100.0f);
            this.graphicsContext.setComposite(alphaComposite);
        }
    }

    @Override
    protected boolean shouldSyncFrames() {
        return true;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return new StandardMediaLoader();
    }

    private Color convertColor(ColorRGB c) {
        if (!this.colorCache.containsKey(c)) {
            this.colorCache.put(c, new Color(c.getR(), c.getG(), c.getB()));
        }
        return this.colorCache.get(c);
    }

    private Dimension convertDimension(Rect r) {
        return new Dimension(r.getWidth(), r.getHeight());
    }

    @Override
    protected Rect getScreenBounds() {
        return this.screenBounds;
    }

    @Override
    protected InputDevice getInputDevice() {
        return this.inputDevice;
    }

    public void setScaleStrategy(ScaleStrategy scaleStrategy) {
        this.scaling = scaleStrategy;
        this.reLayoutCanvas();
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
        this.onDisplayChanged();
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowIcon(BufferedImage windowIcon) {
        this.windowIcon = windowIcon;
        this.onDisplayChanged();
    }

    public BufferedImage getWindowIcon() {
        return this.windowIcon;
    }
}

