/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.RendererException;
import nl.colorize.multimedialib.renderer.java2d.Java2DImage;
import nl.colorize.multimedialib.renderer.java2d.JavaSoundPlayer;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.Utils2D;

public class StandardMediaLoader
implements MediaLoader {
    @Override
    public Image loadImage(ResourceFile source) {
        try {
            BufferedImage loadedImage = Utils2D.loadImage((InputStream)source.openStream());
            BufferedImage compatibleImage = Utils2D.makeImageCompatible((BufferedImage)loadedImage);
            return new Java2DImage(compatibleImage);
        }
        catch (IOException e) {
            throw new RendererException("Cannot load image from " + source.getPath(), e);
        }
    }

    @Override
    public Audio loadAudio(ResourceFile source) {
        return new JavaSoundPlayer(source);
    }
}

