/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.AnimationLoopRenderer;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXSound;
import nl.colorize.multimedialib.renderer.libgdx.GDXTexture;
import nl.colorize.util.ResourceFile;

public class GDXRenderer
extends AnimationLoopRenderer
implements ApplicationListener,
MediaLoader {
    private Rect screenBounds;
    private ColorRGB backgroundColor;
    private Application app;
    private GDXInput input;
    private OrthographicCamera camera;
    private SpriteBatch batch;
    private List<GDXTexture> loadedTextures;
    private List<GDXSound> loadedSounds;
    private Map<ColorRGB, Texture> colorTextureCache;
    private String windowTitle;
    private ResourceFile windowIcon;
    private static final Transform DEFAULT_TRANSFORM = new Transform();
    private static final int COLOR_TEXTURE_SIZE = 8;
    private static final int DESKTOP_TITLE_BAR_HEIGHT = 22;

    public GDXRenderer(ScaleStrategy scaling, int framerate) {
        super(scaling, framerate);
        this.screenBounds = scaling.getPreferredCanvasBounds();
        this.backgroundColor = ColorRGB.WHITE;
    }

    @Override
    public void initialize() {
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(this.screenBounds.getWidth(), this.screenBounds.getHeight());
        config.setDecorated(true);
        if (this.windowTitle != null) {
            config.setTitle(this.windowTitle);
        }
        if (this.windowIcon != null) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{this.windowIcon.getPath()});
        }
        this.input = new GDXInput();
        this.app = new Lwjgl3Application((ApplicationListener)this, config);
    }

    public void create() {
        this.camera = new OrthographicCamera();
        this.resize(this.screenBounds.getWidth(), this.screenBounds.getHeight());
        this.batch = new SpriteBatch();
        this.loadedTextures = new ArrayList<GDXTexture>();
        this.loadedSounds = new ArrayList<GDXSound>();
        this.colorTextureCache = new HashMap<ColorRGB, Texture>();
    }

    @Override
    public void terminate() {
        this.app.exit();
    }

    public void dispose() {
        this.loadedTextures.forEach(texture -> texture.dispose());
        this.loadedTextures.clear();
        this.loadedSounds.forEach(sound -> sound.dispose());
        this.loadedSounds.clear();
        this.colorTextureCache.values().forEach(colorTexture -> colorTexture.dispose());
        this.colorTextureCache.clear();
        this.batch.dispose();
    }

    @Override
    protected boolean shouldSyncFrames() {
        return false;
    }

    public void resize(int width, int height) {
        this.screenBounds.setWidth(width);
        this.screenBounds.setHeight(height);
        this.camera.setToOrtho(false, (float)width, (float)height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        Gdx.gl.glClearColor((float)this.backgroundColor.getR() / 255.0f, (float)this.backgroundColor.getG() / 255.0f, (float)this.backgroundColor.getB() / 255.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.input.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.performFrameUpdate();
        this.batch.end();
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, Transform transform) {
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        Texture colorTexture = this.getColorTexture(color);
        TextureRegion colorTextureRegion = new TextureRegion(colorTexture, 0, 0, colorTexture.getWidth(), colorTexture.getHeight());
        this.draw(rect.getCenterX(), rect.getCenterY(), rect.getWidth(), rect.getHeight(), color, colorTextureRegion, transform);
    }

    @Override
    public void drawImage(Image image, int x, int y, Transform transform) {
        int width = image.getWidth();
        int height = image.getHeight();
        TextureRegion textureRegion = ((GDXTexture)image).getTextureRegion();
        if (transform == null) {
            transform = DEFAULT_TRANSFORM;
        }
        this.draw(x, y, width, height, ColorRGB.WHITE, textureRegion, transform);
    }

    private void draw(int x, int y, int width, int height, ColorRGB color, TextureRegion texture, Transform transform) {
        float canvasX = (float)x - (float)width / 2.0f;
        float canvasY = (float)Math.abs(y - this.getCanvasHeight()) - (float)height / 2.0f;
        float originY = Math.abs(y - this.getCanvasHeight());
        this.batch.setColor((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, 1.0f);
        this.batch.draw(texture, canvasX, canvasY, (float)x, originY, (float)width, (float)height, (float)transform.getScaleX() / 100.0f, (float)transform.getScaleY() / 100.0f, (float)transform.getRotation());
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this;
    }

    @Override
    public Image loadImage(ResourceFile source) {
        Texture texture = new Texture(Gdx.files.internal(source.getPath()));
        GDXTexture gdxTexture = new GDXTexture(texture);
        this.loadedTextures.add(gdxTexture);
        return gdxTexture;
    }

    private Texture getColorTexture(ColorRGB color) {
        Texture colorTexture = this.colorTextureCache.get(color);
        if (colorTexture == null) {
            colorTexture = this.generateColorTexture(color);
            this.colorTextureCache.put(color, colorTexture);
        }
        return colorTexture;
    }

    private Texture generateColorTexture(ColorRGB color) {
        Pixmap pixelData = new Pixmap(8, 8, Pixmap.Format.RGBA8888);
        pixelData.setColor((float)color.getR() / 255.0f, (float)color.getG() / 255.0f, (float)color.getB() / 255.0f, 1.0f);
        pixelData.fillRectangle(0, 0, 8, 8);
        return new Texture(pixelData);
    }

    @Override
    public Audio loadAudio(ResourceFile source) {
        Sound sound = Gdx.audio.newSound(Gdx.files.internal(source.getPath()));
        GDXSound gdxSound = new GDXSound(sound, source);
        this.loadedSounds.add(gdxSound);
        return gdxSound;
    }

    @Override
    protected InputDevice getInputDevice() {
        return this.input;
    }

    @Override
    protected Rect getScreenBounds() {
        return this.screenBounds;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void setWindowIcon(ResourceFile windowIcon) {
        this.windowIcon = windowIcon;
    }
}

