/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class GDXTexture
implements Image {
    private Texture texture;
    private TextureRegion textureRegion;
    private Rect bounds;
    private boolean disposed;

    protected GDXTexture(Texture texture, Rect bounds) {
        this.texture = texture;
        this.textureRegion = new TextureRegion(texture, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.bounds = bounds;
        this.disposed = false;
    }

    protected GDXTexture(Texture texture) {
        this(texture, new Rect(0, 0, texture.getWidth(), texture.getHeight()));
    }

    public Texture getTexture() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Texture has already been disposed");
        return this.texture;
    }

    public TextureRegion getTextureRegion() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"Texture has already been disposed");
        return this.textureRegion;
    }

    @Override
    public int getWidth() {
        return this.bounds.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bounds.getHeight();
    }

    @Override
    public Image getRegion(Rect region) {
        return new GDXTexture(this.texture, region);
    }

    public void dispose() {
        this.texture.dispose();
        this.disposed = true;
    }
}

