/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.List;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.RenderContext;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.animation.Animatable;
import nl.colorize.util.animation.Animator;
import nl.colorize.util.animation.TimedAnimation;

public abstract class AnimatedScene
implements Scene {
    private SceneAnimator animator = new SceneAnimator();

    @Override
    public void onSceneStart(MediaLoader mediaLoader) {
        this.animator.start();
    }

    @Override
    public void onFrame(float deltaTime, InputDevice input) {
        this.animator.onFrame(deltaTime);
    }

    @Override
    public abstract void onRender(RenderContext var1);

    @Override
    public void onSceneEnd() {
        this.animator.stop();
    }

    public void add(Animatable anim) {
        this.animator.play(anim);
    }

    public void add(Animatable anim, float duration) {
        if (anim instanceof TimedAnimation) {
            this.add(anim);
        } else {
            this.add((Animatable)TimedAnimation.from((Animatable)anim, (float)duration));
        }
    }

    public void remove(Animatable anim) {
        this.animator.cancel(anim);
    }

    public void removeAll() {
        this.animator.cancelAll();
    }

    public List<Animatable> getContents() {
        return this.animator.getCurrentlyPlaying();
    }

    public boolean contains(Animatable anim) {
        return this.animator.getCurrentlyPlaying().contains(anim);
    }

    public class SceneAnimator
    extends Animator
    implements Animatable {
        private boolean active = false;

        public void start() {
            this.active = true;
        }

        public void stop() {
            this.active = false;
        }

        public void onFrame(float deltaTime) {
            if (this.active) {
                this.performFrameUpdate(deltaTime);
            }
        }
    }
}

