/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.RenderCallback;
import nl.colorize.multimedialib.renderer.RenderContext;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Scene;

public class SceneManager
implements RenderCallback {
    private Renderer renderer;
    private Scene currentScene;
    private Scene requestedScene;

    public SceneManager(Renderer renderer, Scene initialScene) {
        this.renderer = renderer;
        this.requestedScene = initialScene;
    }

    public void changeScene(Scene requestedScene) {
        this.requestedScene = requestedScene;
    }

    public Scene getCurrentScene() {
        return this.currentScene;
    }

    @Override
    public void onFrame(float deltaTime, InputDevice input) {
        if (this.requestedScene != null) {
            if (this.currentScene != null) {
                this.currentScene.onSceneEnd();
            }
            this.currentScene = this.requestedScene;
            this.requestedScene = null;
            if (this.currentScene != null) {
                this.currentScene.onSceneStart(this.renderer.getMediaLoader());
            }
        }
        if (this.currentScene != null) {
            this.currentScene.onFrame(deltaTime, input);
        }
    }

    @Override
    public void onRender(RenderContext context) {
        if (this.currentScene != null) {
            this.currentScene.onRender(context);
        }
    }
}

