/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.graphics.ImageAtlas;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.multimedialib.tool.ImageAtlasPacker;
import nl.colorize.util.swing.Utils2D;
import org.kohsuke.args4j.Option;

public class BitmapFontCreator
extends CommandLineTool {
    @Option(name="-font", required=true, usage="Name of TrueType font to convert to bitmap font")
    private String fontFace;
    @Option(name="-style", required=false, usage="One of 'plain', 'bold', 'italic'")
    private String fontStyle = "plain";
    @Option(name="-size", required=true, usage="Font size in points")
    private int fontSize;
    @Option(name="-imageWidth", required=true, usage="Width of the font's image atlas")
    private int imageWidth;
    @Option(name="-out", required=true, usage="Output directory")
    private String outputDirPath;
    private static final int ANTI_ALIAS_PADDING = 0;

    public static void main(String[] args) {
        BitmapFontCreator tool = new BitmapFontCreator();
        tool.start(args);
    }

    @Override
    public void run() {
        Font font = this.getTrueTypeFont();
        List<String> alphabet = this.getGlyphsAlphabet();
        Map<String, BufferedImage> glyphImages = this.renderGlyphImages(font, alphabet);
        ImageAtlasPacker imageAtlasPacker = new ImageAtlasPacker();
        ImageAtlas imageAtlas = imageAtlasPacker.createImageAtlas(glyphImages, this.imageWidth);
        File outputDir = this.parseOutputDirectory(this.outputDirPath, true);
        imageAtlasPacker.saveImageAtlas(imageAtlas, outputDir);
    }

    private Font getTrueTypeFont() {
        return new Font(this.fontFace, this.getFontStyleFlags(), this.fontSize);
    }

    private int getFontStyleFlags() {
        if (this.fontStyle.equals("bold")) {
            return 1;
        }
        if (this.fontStyle.equals("italic")) {
            return 2;
        }
        return 0;
    }

    private List<String> getGlyphsAlphabet() {
        String alphabet = " ";
        alphabet = alphabet + "abcdefghijklmnopqrstuvwxyz";
        alphabet = alphabet + "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        alphabet = alphabet + "1234567890";
        alphabet = alphabet + "!@#%&*()-_+=[]:;'\"\\|,./?";
        ArrayList<String> alphabetList = new ArrayList<String>();
        for (int i = 0; i < alphabet.length(); ++i) {
            alphabetList.add(Character.toString(alphabet.charAt(i)));
        }
        return alphabetList;
    }

    private Map<String, BufferedImage> renderGlyphImages(Font font, List<String> alphabet) {
        LinkedHashMap<String, BufferedImage> glyphImages = new LinkedHashMap<String, BufferedImage>();
        for (String letter : alphabet) {
            glyphImages.put(letter, this.renderGlyphImage(font, letter));
        }
        return glyphImages;
    }

    private BufferedImage renderGlyphImage(Font font, String letter) {
        int glyphWidth = this.determineGlyphWidth(font, letter);
        int glyphHeight = this.determineGlyphHeight(font);
        int baseline = Math.round(0.75f * (float)glyphHeight);
        BufferedImage glyphImage = new BufferedImage(glyphWidth, glyphHeight, 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)glyphImage, (boolean)true, (boolean)true);
        Utils2D.drawStringCentered((Graphics2D)g2, (String)letter, (int)(glyphWidth / 2), (int)baseline);
        g2.dispose();
        return glyphImage;
    }

    private int determineGlyphWidth(Font font, String letter) {
        BufferedImage scratchImage = new BufferedImage(64, 64, 2);
        Graphics2D g2 = Utils2D.createGraphics((BufferedImage)scratchImage, (boolean)true, (boolean)true);
        int glyphWidth = g2.getFontMetrics(font).stringWidth(letter) + 0;
        g2.dispose();
        return glyphWidth;
    }

    private int determineGlyphHeight(Font font) {
        return MathUtils.nextPowerOfTwo(font.getSize() + 0);
    }
}

