/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.BitmapFont;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.ImageAtlas;
import nl.colorize.multimedialib.graphics.ImageAtlasLoader;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rand;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.RenderContext;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneManager;
import nl.colorize.multimedialib.tool.CommandLineTool;
import nl.colorize.util.Formatting;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.animation.Animatable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class RendererDemo
extends CommandLineTool
implements Scene {
    @Argument(index=0, metaVar="rendererClass", required=true, usage="Full class name for renderer")
    private String rendererClassName;
    @Option(name="-statsFile", required=false, usage="Output file for storing render statistics")
    private File statsFile;
    private Renderer renderer;
    private ImageAtlas marioImageAtlas;
    private List<Mario> marios;
    private BitmapFont hudFont;
    private Audio audioClip;
    private List<TouchMarker> touchMarkers;
    private Transform shapeTransform;
    private static final int CANVAS_WIDTH = 800;
    private static final int CANVAS_HEIGHT = 600;
    private static final int FRAMERATE = 60;
    private static final ResourceFile MARIO_ATLAS_FILE = new ResourceFile("mario.png");
    private static final ResourceFile MARIO_ATLAS_XML_FILE = new ResourceFile("mario.atlas.xml");
    private static final ResourceFile FONT_IMAGE_FILE = new ResourceFile("lucidagrande.font.png");
    private static final ResourceFile FONT_XML_FILE = new ResourceFile("lucidagrande.font.xml");
    private static final ResourceFile AUDIO_FILE = new ResourceFile("test.mp3");
    private static final int INITIAL_MARIOS = 20;
    private static final List<String> DIRECTIONS = ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west");
    private static final int NUM_BUTTONS = 7;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 22;
    private static final ColorRGB RED_BUTTON = new ColorRGB(228, 93, 97);
    private static final ColorRGB GRAY_BUTTON = new ColorRGB(173, 173, 173);
    private static final ColorRGB GREEN_BUTTON = ColorRGB.parseHex("#72A725");
    private static final ColorRGB SHAPE_COLOR = new ColorRGB(200, 0, 0);
    private static final int TOUCH_MARKER_AGE = 120;
    private static final Logger LOGGER = LogHelper.getLogger(RendererDemo.class, (Handler[])new Handler[0]);

    public static void main(String[] args) {
        RendererDemo demo = new RendererDemo();
        demo.start(args);
    }

    @Override
    public void run() {
        ScaleStrategy scaleStrategy = ScaleStrategy.flexible(800, 600);
        this.renderer = this.createRenderer(scaleStrategy, 60);
        this.renderer.registerCallback(new SceneManager(this.renderer, this));
        this.renderer.initialize();
    }

    private Renderer createRenderer(ScaleStrategy scaling, int framerate) {
        if (this.rendererClassName == null || this.rendererClassName.isEmpty()) {
            return new Java2DRenderer(scaling, framerate);
        }
        try {
            Class<?> rendererClass = Class.forName(this.rendererClassName);
            return (Renderer)rendererClass.getConstructor(ScaleStrategy.class, Integer.TYPE).newInstance(scaling, 60);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while initializing renderer", e);
        }
    }

    @Override
    public void onSceneStart(MediaLoader mediaLoader) {
        ImageAtlasLoader imageAtlasLoader = new ImageAtlasLoader(mediaLoader);
        this.marioImageAtlas = imageAtlasLoader.load(MARIO_ATLAS_FILE, MARIO_ATLAS_XML_FILE);
        this.marios = new ArrayList<Mario>();
        this.addMarios(20);
        this.hudFont = imageAtlasLoader.loadBitmapFont(FONT_IMAGE_FILE, FONT_XML_FILE);
        this.audioClip = mediaLoader.loadAudio(AUDIO_FILE);
        this.touchMarkers = new ArrayList<TouchMarker>();
        this.shapeTransform = new Transform();
    }

    private void handleButtonClick(int index, Renderer renderer) {
        ImmutableMap scaleStrategies = ImmutableMap.of((Object)2, (Object)ScaleStrategy.flexible(800, 600), (Object)3, (Object)ScaleStrategy.fixed(800, 600), (Object)4, (Object)ScaleStrategy.stretch(800, 600), (Object)5, (Object)ScaleStrategy.proportional(800, 600), (Object)6, (Object)ScaleStrategy.smart(800, 600));
        switch (index) {
            case 0: {
                this.addMarios(10);
                break;
            }
            case 1: {
                this.removeMarios(10);
                break;
            }
            case 7: {
                this.audioClip.play();
                break;
            }
            default: {
                this.attemptScaleStrategyChange((ScaleStrategy)scaleStrategies.get(index));
            }
        }
    }

    private void attemptScaleStrategyChange(ScaleStrategy scaleStrategy) {
        if (this.renderer instanceof Java2DRenderer) {
            ((Java2DRenderer)this.renderer).setScaleStrategy(scaleStrategy);
        } else {
            LOGGER.info("Scale strategy change not supported by renderer " + this.renderer.getClass().getSimpleName());
        }
    }

    @Override
    public void onFrame(float deltaTime, InputDevice input) {
        this.updateGraphics(deltaTime, this.renderer);
        this.handleInput(input, this.renderer);
    }

    private void updateGraphics(float deltaTime, Renderer renderer) {
        for (Mario mario : this.marios) {
            mario.onFrame(deltaTime);
        }
        Iterator<TouchMarker> touchMarkerIterator = this.touchMarkers.iterator();
        while (touchMarkerIterator.hasNext()) {
            TouchMarker touchMarker = touchMarkerIterator.next();
            touchMarker.age++;
            if (touchMarker.age < 120) continue;
            touchMarkerIterator.remove();
        }
    }

    private void handleInput(InputDevice input, Renderer renderer) {
        if (input.isPointerReleased()) {
            for (int i = 0; i <= 7; ++i) {
                if (!this.isButtonClicked(input, i)) continue;
                this.handleButtonClick(i, renderer);
                return;
            }
            Point2D pointer = input.getPointer();
            if (pointer.getX() <= 100.0f && pointer.getY() >= (float)(renderer.getCanvasHeight() - 100)) {
                this.randomizeShapeTransform();
                return;
            }
            this.touchMarkers.add(new TouchMarker(pointer.getX(), pointer.getY()));
        }
    }

    private boolean isButtonClicked(InputDevice inputDevice, int buttonIndex) {
        Rect buttonBounds = new Rect(this.renderer.getCanvasWidth() - 100, buttonIndex * 25, 100, 22);
        return buttonBounds.contains(inputDevice.getPointer());
    }

    private void randomizeShapeTransform() {
        if (Math.random() >= 0.5) {
            this.shapeTransform.setRotation(this.shapeTransform.getRotation() + 45);
        } else {
            this.shapeTransform.setScale(this.shapeTransform.getScaleX() + 10, this.shapeTransform.getScaleX() + 10);
        }
    }

    @Override
    public void onRender(RenderContext context) {
        context.drawBackground(ColorRGB.BLACK);
        this.drawSprites(context);
        this.drawHUD(context);
    }

    private void drawSprites(RenderContext context) {
        for (Mario mario : this.marios) {
            context.drawSprite(mario.sprite, Math.round(mario.position.getX()), Math.round(mario.position.getY()), null);
        }
        context.drawRect(new Rect(10, this.renderer.getCanvasHeight() - 110, 100, 100), SHAPE_COLOR, this.shapeTransform);
        for (TouchMarker touchMarker : this.touchMarkers) {
            context.drawText(touchMarker.text, this.hudFont, (int)touchMarker.location.getX(), (int)touchMarker.location.getY());
        }
    }

    private void drawHUD(RenderContext context) {
        this.drawButton(context, "Add sprites", RED_BUTTON, 0);
        this.drawButton(context, "Remove sprites", RED_BUTTON, 25);
        this.drawButton(context, "Flexible scaling", GRAY_BUTTON, 50);
        this.drawButton(context, "Fixed scaling", GRAY_BUTTON, 75);
        this.drawButton(context, "Stretch scaling", GRAY_BUTTON, 100);
        this.drawButton(context, "Prop. scaling", GRAY_BUTTON, 125);
        this.drawButton(context, "Smart scaling", GRAY_BUTTON, 150);
        this.drawButton(context, "Play sound", GREEN_BUTTON, 175);
        context.drawText("Canvas: " + this.renderer.getCanvasWidth() + "x" + this.renderer.getCanvasHeight(), this.hudFont, 20, 20);
        context.drawText("Framerate: " + Formatting.numberFormat((float)this.renderer.getStats().getAverageFPS(), (int)1) + " / " + this.renderer.getTargetFramerate(), this.hudFont, 20, 40);
        context.drawText("# Sprites: " + this.marios.size(), this.hudFont, 20, 60);
    }

    private void drawButton(RenderContext context, String label, ColorRGB background, int y) {
        context.drawRect(new Rect(this.renderer.getCanvasWidth() - 100 - 2, y + 2, 100, 22), background, null);
        context.drawText(label, this.hudFont, this.renderer.getCanvasWidth() - 100 + 5, y + 17);
    }

    @Override
    public void onSceneEnd() {
    }

    public void addMarios(int amount) {
        for (int i = 0; i < amount; ++i) {
            Sprite marioSprite = this.createMarioSprite();
            this.marios.add(new Mario(marioSprite, new Rect(0, 0, this.renderer.getCanvasWidth(), this.renderer.getCanvasHeight())));
        }
    }

    private Sprite createMarioSprite() {
        Sprite marioSprite = new Sprite();
        for (String direction : DIRECTIONS) {
            List<Image> frames = this.marioImageAtlas.getSubImages(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4");
            Animation anim = new Animation(frames, 0.1f, true);
            marioSprite.addState(direction, anim);
        }
        return marioSprite;
    }

    private void removeMarios(int amount) {
        for (int i = 0; i < amount && !this.marios.isEmpty(); ++i) {
            this.marios.remove(this.marios.size() - 1);
        }
    }

    private static class TouchMarker {
        private String text;
        private Point2D location;
        private int age;

        public TouchMarker(float x, float y) {
            this.text = x + ", " + y;
            this.location = new Point2D(x, y);
        }
    }

    private static class Mario
    implements Animatable {
        private Sprite sprite;
        private Rect canvasBounds;
        private Point2D position;
        private int direction;
        private int speed;

        public Mario(Sprite sprite, Rect canvasBounds) {
            this.sprite = sprite;
            this.position = new Point2D(Rand.nextInt(0, canvasBounds.getWidth()), Rand.nextInt(0, canvasBounds.getHeight()));
            this.canvasBounds = canvasBounds;
            this.direction = Rand.nextInt(0, 4);
            this.speed = Rand.nextInt(1, 4);
        }

        public void onFrame(float deltaTime) {
            this.sprite.changeState((String)DIRECTIONS.get(this.direction));
            this.sprite.onFrame(deltaTime);
            switch (this.direction) {
                case 0: {
                    this.position.set(0.0f, -this.speed);
                    break;
                }
                case 1: {
                    this.position.set(this.speed, 0.0f);
                    break;
                }
                case 2: {
                    this.position.set(0.0f, this.speed);
                    break;
                }
                case 3: {
                    this.position.set(-this.speed, 0.0f);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.checkBounds();
        }

        private void checkBounds() {
            if (this.position.getX() < 0.0f || this.position.getX() > (float)this.canvasBounds.getWidth() || this.position.getY() < 0.0f || this.position.getY() > (float)this.canvasBounds.getHeight()) {
                this.direction = (this.direction + 2) % 4;
            }
        }
    }
}

