/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class ImageAtlas {
    private Image sourceImage;
    private Map<String, Image> subImages;
    private Map<String, Rect> subImageBounds;

    public ImageAtlas(Image sourceImage) {
        this.sourceImage = sourceImage;
        this.subImages = new HashMap<String, Image>();
        this.subImageBounds = new HashMap<String, Rect>();
    }

    public void markSubImage(String name, Rect region) {
        Preconditions.checkArgument((!this.subImages.containsKey(name) ? 1 : 0) != 0, (Object)("Sub-image already exists: " + name));
        this.subImages.put(name, this.sourceImage.getRegion(region));
        this.subImageBounds.put(name, region);
    }

    public Image getSubImage(String name) {
        Image subImage = this.subImages.get(name);
        Preconditions.checkArgument((subImage != null ? 1 : 0) != 0, (Object)("Sub-image not found: " + name));
        return subImage;
    }

    public Rect getSubImageBounds(String name) {
        Rect bounds = this.subImageBounds.get(name);
        Preconditions.checkArgument((bounds != null ? 1 : 0) != 0, (Object)("Sub-image not found: " + name));
        return bounds;
    }

    public boolean containsSubImage(String name) {
        return this.subImages.containsKey(name);
    }

    public Map<String, Image> getSubImages() {
        return ImmutableMap.copyOf(this.subImages);
    }

    public List<Image> getSubImages(List<String> names) {
        ArrayList<Image> subImages = new ArrayList<Image>();
        for (String name : names) {
            subImages.add(this.getSubImage(name));
        }
        return subImages;
    }

    public List<Image> getSubImages(String ... names) {
        return this.getSubImages((List<String>)ImmutableList.copyOf((Object[])names));
    }

    public Image getSourceImage() {
        return this.sourceImage;
    }
}

