/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.graphics.Alignment;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;

public interface GraphicsContext {
    public Canvas getCanvas();

    default public int getCanvasWidth() {
        return this.getCanvas().getWidth();
    }

    default public int getCanvasHeight() {
        return this.getCanvas().getHeight();
    }

    public void drawBackground(ColorRGB var1);

    public void drawRect(Rect var1, ColorRGB var2, Transform var3);

    public void drawPolygon(Polygon var1, ColorRGB var2, Transform var3);

    public void drawImage(Image var1, float var2, float var3, Transform var4);

    default public void drawSprite(Sprite sprite, float x, float y, Transform transform) {
        this.drawImage(sprite.getCurrentGraphics(), x, y, transform);
    }

    public void drawText(String var1, TrueTypeFont var2, float var3, float var4, Alignment var5);

    default public void drawText(String text, TrueTypeFont font, float x, float y) {
        this.drawText(text, font, x, y, Alignment.LEFT);
    }
}

