/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.badlogic.gdx.math.MathUtils;
import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferStrategy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import nl.colorize.multimedialib.renderer.AbstractRenderer;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.AWTInput;
import nl.colorize.multimedialib.renderer.java2d.Java2DGraphicsContext;
import nl.colorize.multimedialib.renderer.java2d.StandardApplicationData;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.Stopwatch;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.MacIntegration;
import nl.colorize.util.swing.SwingUtils;
import nl.colorize.util.swing.Utils2D;

public class Java2DRenderer
extends AbstractRenderer {
    private int framerate;
    private Stopwatch syncTimer;
    private StandardMediaLoader mediaLoader;
    private AWTInput inputDevice;
    private JFrame window;
    private BufferStrategy windowBuffer;
    private Java2DGraphicsContext graphicsContext;
    private AtomicBoolean canvasDirty;
    private static final boolean ANTI_ALIASING = true;
    private static final boolean BILINEAR_SCALING = true;
    private static final long MIN_SLEEP_TIME = 1L;
    private static final long MAX_SLEEP_TIME = 50L;
    private static final Logger LOGGER = LogHelper.getLogger(Java2DRenderer.class);

    public Java2DRenderer(Canvas canvas, int framerate, WindowOptions windowOptions) {
        super(canvas);
        Preconditions.checkArgument((framerate >= 1 && framerate <= 120 ? 1 : 0) != 0, (Object)("Invalid framerate: " + framerate));
        SwingUtils.initializeSwing();
        this.framerate = framerate;
        this.syncTimer = new Stopwatch();
        this.mediaLoader = new StandardMediaLoader();
        this.canvasDirty = new AtomicBoolean(true);
        this.initializeWindow(windowOptions);
        this.initializeInput();
        this.window.createBufferStrategy(2);
        this.windowBuffer = this.window.getBufferStrategy();
        Thread renderingThread = new Thread(this::runAnimationLoop, "MultimediaLib-RenderingThread");
        renderingThread.start();
    }

    private void initializeWindow(WindowOptions windowOptions) {
        this.window = new JFrame();
        this.window.setDefaultCloseOperation(3);
        this.window.setResizable(true);
        this.window.setIgnoreRepaint(true);
        this.window.setFocusTraversalKeysEnabled(false);
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Java2DRenderer.this.canvasDirty.set(true);
            }
        });
        this.window.setTitle(windowOptions.getTitle());
        this.window.setIconImage(this.loadIcon(windowOptions));
        this.window.setLayout(new BorderLayout());
        this.window.add((Component)this.createCanvasPanel(), "Center");
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
        if (Platform.isMac()) {
            MacIntegration.setApplicationMenuListener((ApplicationMenuListener)windowOptions.getAppMenuListener(), (boolean)false);
        }
    }

    private Image loadIcon(WindowOptions windowOptions) {
        if (windowOptions.hasIcon()) {
            return SwingUtils.loadIcon((ResourceFile)windowOptions.getIconFile()).getImage();
        }
        return null;
    }

    private JPanel createCanvasPanel() {
        Canvas canvas = this.getCanvas();
        JPanel canvasPanel = new JPanel();
        canvasPanel.setPreferredSize(new Dimension(canvas.getWidth(), canvas.getHeight()));
        canvasPanel.setOpaque(false);
        canvasPanel.setFocusable(false);
        return canvasPanel;
    }

    private void initializeInput() {
        this.inputDevice = new AWTInput(this.getCanvas());
        this.window.addKeyListener(this.inputDevice);
        this.window.addMouseListener(this.inputDevice);
        this.window.addMouseMotionListener(this.inputDevice);
        this.addUpdateCallback(this.inputDevice);
    }

    private void runAnimationLoop() {
        while (true) {
            this.syncTimer.tick();
            if (this.canvasDirty.get()) {
                this.canvasDirty.set(false);
                this.prepareCanvas();
            }
            Graphics bufferGraphics = this.windowBuffer.getDrawGraphics();
            Graphics2D g2 = Utils2D.createGraphics((Graphics)bufferGraphics, (boolean)true, (boolean)true);
            this.graphicsContext.bind(g2);
            this.performFrameUpdate();
            this.performFrameRender(g2);
            this.blitGraphicsContext();
            this.graphicsContext.dispose();
            long elapsedTime = this.syncTimer.tock();
            this.syncFrame(elapsedTime);
        }
    }

    private void prepareCanvas() {
        Insets windowInsets = this.window.getInsets();
        int windowWidth = this.window.getWidth() - windowInsets.left - windowInsets.right;
        int windowHeight = this.window.getHeight() - windowInsets.top - windowInsets.bottom;
        Canvas canvas = this.getCanvas();
        canvas.resize(windowWidth, windowHeight);
        canvas.offset(windowInsets.left, windowInsets.top);
        this.graphicsContext = new Java2DGraphicsContext(canvas, this.mediaLoader);
    }

    private void performFrameUpdate() {
        float frameTime = 1.0f / (float)this.framerate;
        this.notifyUpdateCallbacks(frameTime);
    }

    private void performFrameRender(Graphics2D g2) {
        Canvas canvas = this.getCanvas();
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, this.window.getWidth(), this.window.getHeight());
        this.notifyRenderCallbacks(this.graphicsContext);
    }

    private void syncFrame(long elapsedFrameTime) {
        long target = 1000L / (long)this.framerate;
        long sleepTime = target - elapsedFrameTime;
        sleepTime = MathUtils.clamp((long)sleepTime, (long)1L, (long)50L);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOGGER.warning("Frame sync interrupted");
        }
    }

    private void blitGraphicsContext() {
        if (!this.windowBuffer.contentsLost()) {
            this.windowBuffer.show();
            if (Platform.isLinux()) {
                this.window.getToolkit().sync();
            }
        }
        this.graphicsContext.dispose();
        Thread.yield();
    }

    @Override
    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return new StandardApplicationData(appName);
    }
}

