/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.util.LoadUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;

public class StandardApplicationData
implements ApplicationData {
    private Properties data;
    private File preferencesFile;
    private static final String PREFERENCES_FILE_NAME = "preferences.properties";
    private static final Logger LOGGER = LogHelper.getLogger(StandardApplicationData.class);

    public StandardApplicationData(String applicationName) {
        Preconditions.checkArgument((applicationName.trim().length() >= 2 ? 1 : 0) != 0, (Object)"Invalid application name");
        this.data = new Properties();
        this.preferencesFile = Platform.getApplicationData((String)applicationName, (String)PREFERENCES_FILE_NAME);
        if (this.preferencesFile.exists()) {
            try {
                this.data = LoadUtils.loadProperties((File)this.preferencesFile, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                LOGGER.warning("Cannot load application data: " + e.getMessage());
            }
        }
    }

    @Override
    public String get(String key, String defaultValue) {
        String value = this.data.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public void set(String key, String value) {
        this.data.setProperty(key, value);
        this.save();
    }

    @Override
    public void clear() {
        this.data.clear();
        this.save();
    }

    private void save() {
        try {
            LoadUtils.saveProperties((Properties)this.data, (File)this.preferencesFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.warning("Cannot save application data: " + e.getMessage());
        }
    }
}

