/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.ApplicationData;

public class GDXApplicationData
implements ApplicationData {
    private Preferences preferences;

    public GDXApplicationData(String applicationName) {
        Preconditions.checkArgument((applicationName.trim().length() >= 2 ? 1 : 0) != 0, (Object)"Invalid application name");
        this.preferences = Gdx.app.getPreferences(applicationName);
    }

    @Override
    public String get(String key, String defaultValue) {
        String value = this.preferences.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public void set(String key, String value) {
        this.preferences.putString(key, value);
        this.preferences.flush();
    }

    @Override
    public void clear() {
        this.preferences.clear();
        this.preferences.flush();
    }
}

