/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.scene.Updatable;

public class TeaInputDevice
implements InputDevice,
Updatable {
    private Point pointer = new Point(0.0f, 0.0f);
    private boolean pointerDown = false;
    private boolean pointerUp = false;
    private Set<Integer> keysDown = new HashSet<Integer>();
    private Set<Integer> keysUp = new HashSet<Integer>();
    private static final Map<KeyCode, Integer> BROWSER_KEY_CODE_MAPPING = new ImmutableMap.Builder().put((Object)KeyCode.LEFT, (Object)37).put((Object)KeyCode.RIGHT, (Object)39).put((Object)KeyCode.UP, (Object)38).put((Object)KeyCode.DOWN, (Object)40).put((Object)KeyCode.ENTER, (Object)13).put((Object)KeyCode.SPACEBAR, (Object)32).put((Object)KeyCode.ESCAPE, (Object)27).put((Object)KeyCode.A, (Object)65).put((Object)KeyCode.B, (Object)66).put((Object)KeyCode.C, (Object)67).put((Object)KeyCode.D, (Object)68).put((Object)KeyCode.E, (Object)69).put((Object)KeyCode.F, (Object)70).put((Object)KeyCode.G, (Object)71).put((Object)KeyCode.H, (Object)72).put((Object)KeyCode.I, (Object)73).put((Object)KeyCode.J, (Object)74).put((Object)KeyCode.K, (Object)75).put((Object)KeyCode.L, (Object)76).put((Object)KeyCode.M, (Object)77).put((Object)KeyCode.N, (Object)78).put((Object)KeyCode.O, (Object)79).put((Object)KeyCode.P, (Object)80).put((Object)KeyCode.Q, (Object)81).put((Object)KeyCode.R, (Object)82).put((Object)KeyCode.S, (Object)83).put((Object)KeyCode.T, (Object)84).put((Object)KeyCode.U, (Object)85).put((Object)KeyCode.V, (Object)86).put((Object)KeyCode.W, (Object)87).put((Object)KeyCode.X, (Object)88).put((Object)KeyCode.Y, (Object)89).put((Object)KeyCode.Z, (Object)90).put((Object)KeyCode.N1, (Object)49).put((Object)KeyCode.N2, (Object)50).put((Object)KeyCode.N3, (Object)51).put((Object)KeyCode.N4, (Object)52).put((Object)KeyCode.N5, (Object)53).put((Object)KeyCode.N6, (Object)54).put((Object)KeyCode.N7, (Object)55).put((Object)KeyCode.N8, (Object)56).put((Object)KeyCode.N9, (Object)57).put((Object)KeyCode.N0, (Object)48).build();

    @Override
    public void update(float deltaTime) {
        this.updatePointerState();
        this.updateKeyboardState();
    }

    private void updatePointerState() {
        this.pointer.setX(Browser.getPointerX());
        this.pointer.setY(Browser.getPointerY());
        int pointerState = Math.round(Browser.getPointerState());
        if (pointerState == 1) {
            this.pointerDown = true;
            this.pointerUp = false;
        } else if (this.pointerDown) {
            this.pointerDown = false;
            this.pointerUp = true;
        } else {
            this.pointerDown = false;
            this.pointerUp = false;
        }
    }

    private void updateKeyboardState() {
        for (KeyCode keyCode : KeyCode.values()) {
            Integer browserKeyCode = BROWSER_KEY_CODE_MAPPING.get((Object)keyCode);
            int keyState = Math.round(Browser.getKeyState(browserKeyCode));
            if (keyState == 1) {
                this.keysDown.add(browserKeyCode);
                this.keysUp.remove(browserKeyCode);
                continue;
            }
            if (this.keysDown.contains(browserKeyCode)) {
                this.keysDown.remove(browserKeyCode);
                this.keysUp.add(browserKeyCode);
                continue;
            }
            this.keysDown.remove(browserKeyCode);
            this.keysUp.remove(browserKeyCode);
        }
    }

    @Override
    public Point getPointer() {
        return this.pointer.copy();
    }

    @Override
    public boolean isPointerPressed() {
        return this.pointerDown;
    }

    @Override
    public boolean isPointerReleased() {
        return this.pointerUp;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return true;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return this.keysDown.contains(BROWSER_KEY_CODE_MAPPING.get((Object)keyCode));
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return this.keysUp.contains(BROWSER_KEY_CODE_MAPPING.get((Object)keyCode));
    }
}

