/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;

public class TeaMediaLoader
implements MediaLoader {
    private Map<Image, String> imageIds = new HashMap<Image, String>();
    private Map<Audio, String> audioIds = new HashMap<Audio, String>();
    private Map<TrueTypeFont, String> fontIds = new HashMap<TrueTypeFont, String>();
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();

    @Override
    public Image loadImage(FilePointer file) {
        String id = String.valueOf(this.imageIds.size() + 1);
        Browser.loadImage(id, this.normalizeFilePath(file, false));
        TeaImage imagePointer = new TeaImage(id, this.normalizeFilePath(file, false), null);
        this.imageIds.put(imagePointer, id);
        return imagePointer;
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        String id = String.valueOf(this.audioIds.size() + 1);
        Browser.loadAudio(id, this.normalizeFilePath(file, false));
        return new TeaAudio(id);
    }

    @Override
    public TrueTypeFont loadFont(String fontFamily, FilePointer file) {
        String id = String.valueOf(this.fontIds.size() + 1);
        Browser.loadFont(id, this.normalizeFilePath(file, false), fontFamily);
        return new TrueTypeFont(fontFamily, 12, ColorRGB.BLACK);
    }

    @Override
    public String loadText(FilePointer file) {
        return Browser.loadTextResourceFile(this.normalizeFilePath(file, true));
    }

    private List<FilePointer> loadResourceFileManifest() {
        String manifest = this.loadText(new FilePointer("resource-file-manifest"));
        return LINE_SPLITTER.splitToList((CharSequence)manifest).stream().map(path -> new FilePointer((String)path)).collect(Collectors.toList());
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        String fileEntry = file.getPath();
        if (fileEntry.indexOf(47) != -1) {
            fileEntry = fileEntry.substring(fileEntry.lastIndexOf(47) + 1);
        }
        for (FilePointer entry : this.loadResourceFileManifest()) {
            if (!entry.getPath().equals(fileEntry)) continue;
            return true;
        }
        return false;
    }

    private String normalizeFilePath(FilePointer file, boolean replaceDot) {
        String normalized = file.getPath();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }
}

