/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.graphics.Alignment;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.ApplicationData;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.teavm.AnimationFrameCallback;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaLocalStorage;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.scene.Renderable;
import nl.colorize.multimedialib.scene.Updatable;

public class TeaRenderer
implements Renderer,
GraphicsContext,
AnimationFrameCallback {
    private Canvas canvas;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private TeaLocalStorage localStorage;
    private List<Updatable> updateCallbacks;
    private List<Renderable> renderCallbacks;
    private static final int HTML_CANVAS_ANIMATION_FRAMERATE = 60;
    private static final Transform NULL_TRANSFORM = new Transform();

    public TeaRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.inputDevice = new TeaInputDevice();
        this.mediaLoader = new TeaMediaLoader();
        this.localStorage = new TeaLocalStorage();
        this.updateCallbacks = new ArrayList<Updatable>();
        this.renderCallbacks = new ArrayList<Renderable>();
        Browser.renderFrame(this);
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public ApplicationData getApplicationData(String appName) {
        return this.localStorage;
    }

    @Override
    public void addUpdateCallback(Updatable callback) {
        this.updateCallbacks.add(callback);
    }

    @Override
    public void addRenderCallback(Renderable callback) {
        this.renderCallbacks.add(callback);
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        this.drawRect(new Rect(0.0f, 0.0f, this.canvas.getWidth(), this.canvas.getHeight()), backgroundColor, null);
    }

    @Override
    public void drawRect(Rect rect, ColorRGB color, Transform transform) {
        if (transform == null) {
            transform = NULL_TRANSFORM;
        }
        float x = this.canvas.toScreenX(rect.getX());
        float y = this.canvas.toScreenX(rect.getY());
        float width = this.canvas.toScreenX(rect.getWidth());
        float height = this.canvas.toScreenX(rect.getHeight());
        Browser.drawRect(x, y, width, height, color.toHex(), (float)transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawPolygon(Polygon polygon, ColorRGB color, Transform transform) {
        if (transform == null) {
            transform = NULL_TRANSFORM;
        }
        float[] points = new float[polygon.getPoints().length];
        for (int i = 0; i < polygon.getPoints().length; i += 2) {
            points[i] = this.canvas.toScreenX(polygon.getPoints()[i]);
            points[i + 1] = this.canvas.toScreenY(polygon.getPoints()[i + 1]);
        }
        Browser.drawPolygon(points, color.toHex(), (float)transform.getAlpha() / 100.0f);
    }

    @Override
    public void drawImage(Image image, float x, float y, Transform transform) {
        if (transform == null) {
            transform = NULL_TRANSFORM;
        }
        TeaImage pointer = (TeaImage)image;
        float canvasX = this.canvas.toScreenX(x);
        float canvasY = this.canvas.toScreenY(y);
        if (pointer.getRegion() == null) {
            float width = (float)image.getWidth() * this.canvas.getZoomLevel();
            float height = (float)image.getHeight() * this.canvas.getZoomLevel();
            Browser.drawImage(pointer.getId(), canvasX - width / 2.0f, canvasY - height / 2.0f, width, height, (float)transform.getAlpha() / 100.0f, this.getMask(transform));
        } else {
            Rect region = pointer.getRegion();
            float width = region.getWidth() * this.canvas.getZoomLevel();
            float height = region.getHeight() * this.canvas.getZoomLevel();
            Browser.drawImageRegion(pointer.getId(), region.getX(), region.getY(), region.getWidth(), region.getHeight(), canvasX, canvasY, width, height, (float)transform.getAlpha() / 100.0f, this.getMask(transform));
        }
    }

    @Override
    public void drawText(String text, TrueTypeFont font, float x, float y, Alignment align) {
        float canvasX = this.canvas.toScreenX(x);
        float canvasY = this.canvas.toScreenY(y);
        Browser.drawText(text, font.getFamily(), font.getSize(), font.getColor().toHex(), canvasX, canvasY, align.toString().toLowerCase());
    }

    @Override
    public void onRenderFrame() {
        float deltaTime = 0.016666668f;
        this.updateCanvas();
        this.inputDevice.update(deltaTime);
        for (Updatable updateCallback : this.updateCallbacks) {
            updateCallback.update(deltaTime);
        }
        for (Renderable renderCallback : this.renderCallbacks) {
            renderCallback.render(this);
        }
    }

    private void updateCanvas() {
        int canvasWidth = Math.round(Browser.getCanvasWidth());
        int canvasHeight = Math.round(Browser.getCanvasHeight());
        if (canvasWidth > 0 && canvasHeight > 0) {
            this.canvas.resize(canvasWidth, canvasHeight);
        }
    }

    private String getMask(Transform transform) {
        if (transform == null || transform.getMask() == null) {
            return null;
        }
        return transform.getMask().toHex();
    }
}

