/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Subsystem;

public class ComplexScene
implements Scene {
    private List<Subsystem> subsystems = new ArrayList<Subsystem>();
    private SceneContext context;

    public void register(Subsystem subsystem) {
        Preconditions.checkState((this.context == null ? 1 : 0) != 0, (Object)"Subsystem cannot be registered, scene has already started");
        this.subsystems.add(subsystem);
    }

    @Override
    public void start(SceneContext context) {
        this.context = context;
        for (Subsystem subsystem : this.subsystems) {
            subsystem.init();
        }
    }

    @Override
    public void update(float deltaTime) {
        for (Subsystem subsystem : this.subsystems) {
            subsystem.update(deltaTime);
        }
    }

    @Override
    public void render(GraphicsContext graphics) {
        for (Subsystem subsystem : this.subsystems) {
            subsystem.render(graphics);
        }
    }

    public SceneContext getContext() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"Scene has not started yet");
        return this.context;
    }
}

