/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.function.BiConsumer;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.scene.Renderable;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.animation.Timeline;

public class Effect
implements Updatable,
Renderable {
    private Sprite sprite;
    private Point position;
    private Transform transform;
    private Timeline timeline;
    private BiConsumer<Effect, Float> callback;

    public Effect(Sprite sprite, Timeline timeline, BiConsumer<Effect, Float> callback) {
        this.sprite = sprite;
        this.position = new Point(0.0f, 0.0f);
        this.transform = new Transform();
        this.timeline = timeline;
        this.callback = callback;
    }

    public Effect(Animation anim, Timeline timeline, BiConsumer<Effect, Float> callback) {
        this(Effect.createSprite(anim), timeline, callback);
    }

    public Effect(Image image, Timeline timeline, BiConsumer<Effect, Float> callback) {
        this(Effect.createSprite(image), timeline, callback);
    }

    public Point getPosition() {
        return this.position;
    }

    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public void update(float deltaTime) {
        this.timeline.onFrame(deltaTime);
        this.callback.accept(this, Float.valueOf(this.timeline.getValue()));
    }

    public boolean isCompleted() {
        return this.timeline.isCompleted();
    }

    @Override
    public void render(GraphicsContext graphics) {
        graphics.drawSprite(this.sprite, this.position.getX(), this.position.getY(), this.transform);
    }

    private static Sprite createSprite(Animation graphics) {
        Sprite sprite = new Sprite();
        sprite.addState("_effect", graphics);
        return sprite;
    }

    private static Sprite createSprite(Image graphics) {
        Sprite sprite = new Sprite();
        sprite.addState("_effect", graphics);
        return sprite;
    }
}

