/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.colorize.multimedialib.graphics.Alignment;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.ImageAtlas;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.math.Point;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;

public class DemoApplication
implements Scene {
    private Renderer renderer;
    private SceneContext sceneContext;
    private ImageAtlas marioImageAtlas;
    private TrueTypeFont font;
    private List<Mario> marios;
    private Audio audioClip;
    private List<TouchMarker> touchMarkers;
    private Transform shapeTransform;
    private boolean mask;
    private static final FilePointer MARIO_SPRITES_FILE = new FilePointer("mario.png");
    private static final FilePointer AUDIO_FILE = new FilePointer("test.mp3");
    private static final int INITIAL_MARIOS = 20;
    private static final List<String> DIRECTIONS = ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west");
    private static final int NUM_BUTTONS = 7;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 25;
    private static final ColorRGB RED_BUTTON = new ColorRGB(228, 93, 97);
    private static final ColorRGB GREEN_BUTTON = ColorRGB.parseHex("#72A725");
    private static final ColorRGB SHAPE_COLOR = new ColorRGB(200, 0, 0);
    private static final int TOUCH_MARKER_AGE = 120;
    private static final ColorRGB BACKGROUND_COLOR = ColorRGB.parseHex("#343434");
    private static final Transform MASK_TRANSFORM = Transform.withMask(ColorRGB.WHITE);

    public DemoApplication(Renderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public void start(SceneContext sceneContext) {
        this.sceneContext = sceneContext;
        MediaLoader mediaLoader = sceneContext.getMediaLoader();
        this.initMarioSprites(mediaLoader);
        this.marios = new ArrayList<Mario>();
        this.addMarios(20);
        this.font = mediaLoader.loadDefaultFont().derive(ColorRGB.WHITE);
        this.audioClip = mediaLoader.loadAudio(AUDIO_FILE);
        this.touchMarkers = new ArrayList<TouchMarker>();
        this.shapeTransform = new Transform();
    }

    private void initMarioSprites(MediaLoader mediaLoader) {
        Image image = mediaLoader.loadImage(MARIO_SPRITES_FILE);
        this.marioImageAtlas = new ImageAtlas(image);
        int y = 0;
        for (String direction : ImmutableList.of((Object)"north", (Object)"east", (Object)"south", (Object)"west")) {
            for (int i = 0; i <= 4; ++i) {
                this.marioImageAtlas.markSubImage(direction + "_" + i, new Rect(i * 48, y, 48.0f, 64.0f));
            }
            y += 64;
        }
    }

    @Override
    public void update(float deltaTime) {
        this.handleInput(this.renderer.getInputDevice());
        this.updatePositions(deltaTime);
    }

    private void handleInput(InputDevice inputDevice) {
        if (inputDevice.isPointerReleased()) {
            for (int i = 0; i <= 7; ++i) {
                if (!this.isButtonClicked(i)) continue;
                this.handleButtonClick(i);
                return;
            }
            Point pointer = inputDevice.getPointer();
            if (pointer.getX() <= 100.0f && pointer.getY() >= (float)(this.renderer.getCanvas().getHeight() - 100)) {
                this.randomizeShapeTransform();
                return;
            }
            this.touchMarkers.add(new TouchMarker(pointer.getX(), pointer.getY()));
        }
    }

    private boolean isButtonClicked(int buttonIndex) {
        Rect buttonBounds = new Rect(this.renderer.getCanvas().getWidth() - 100, buttonIndex * 30, 100.0f, 25.0f);
        return buttonBounds.contains(this.renderer.getInputDevice().getPointer());
    }

    private void handleButtonClick(int index) {
        switch (index) {
            case 0: {
                this.addMarios(10);
                break;
            }
            case 1: {
                this.removeMarios(10);
                break;
            }
            case 2: {
                this.audioClip.play();
                break;
            }
        }
    }

    private void updatePositions(float deltaTime) {
        for (Mario mario : this.marios) {
            mario.update(deltaTime);
        }
        Iterator<TouchMarker> touchMarkerIterator = this.touchMarkers.iterator();
        while (touchMarkerIterator.hasNext()) {
            TouchMarker touchMarker = touchMarkerIterator.next();
            ++touchMarker.age;
            if (touchMarker.age < 120) continue;
            touchMarkerIterator.remove();
        }
    }

    private void randomizeShapeTransform() {
        if (Math.random() >= 0.5) {
            this.shapeTransform.setRotation(this.shapeTransform.getRotation() + 45);
        } else {
            this.shapeTransform.setScale(this.shapeTransform.getScaleX() + 10, this.shapeTransform.getScaleX() + 10);
        }
    }

    @Override
    public void render(GraphicsContext context) {
        context.drawBackground(BACKGROUND_COLOR);
        this.drawSprites(context);
        this.drawHUD(context);
    }

    private void drawSprites(GraphicsContext context) {
        for (Mario mario : this.marios) {
            context.drawSprite(mario.sprite, Math.round(mario.position.getX()), Math.round(mario.position.getY()), this.mask ? MASK_TRANSFORM : null);
        }
        context.drawRect(new Rect(10.0f, this.renderer.getCanvas().getHeight() - 110, 100.0f, 100.0f), SHAPE_COLOR, this.shapeTransform);
        Polygon circle = Polygon.createCircle(10.0f, this.renderer.getCanvas().getHeight() - 110, 20.0f, 16);
        context.drawPolygon(circle, ColorRGB.WHITE, Transform.withAlpha(50));
        for (TouchMarker touchMarker : this.touchMarkers) {
            context.drawText(touchMarker.text, this.font, (int)touchMarker.location.getX(), (int)touchMarker.location.getY(), Alignment.LEFT);
        }
    }

    private void drawHUD(GraphicsContext context) {
        this.drawButton(context, "Add sprites", RED_BUTTON, 0);
        this.drawButton(context, "Remove sprites", RED_BUTTON, 30);
        this.drawButton(context, "Play sound", GREEN_BUTTON, 60);
        Canvas canvas = this.renderer.getCanvas();
        context.drawText(String.format("Canvas:  %dx%d @ %dx", canvas.getWidth(), canvas.getHeight(), Math.round(canvas.getZoomLevel())), this.font, 20.0f, 20.0f, Alignment.LEFT);
        context.drawText("Framerate:  " + Math.round(this.sceneContext.getAverageFPS()), this.font, 20.0f, 40.0f, Alignment.LEFT);
        context.drawText("Frame time:  " + Math.round(this.sceneContext.getAverageFrameTime()) + "ms", this.font, 20.0f, 60.0f, Alignment.LEFT);
        context.drawText("Sprites:  " + this.marios.size(), this.font, 20.0f, 80.0f, Alignment.LEFT);
    }

    private void drawButton(GraphicsContext context, String label, ColorRGB background, int y) {
        context.drawRect(new Rect(this.renderer.getCanvas().getWidth() - 100 - 2, y + 2, 100.0f, 25.0f), background, null);
        context.drawText(label, this.font, (float)this.renderer.getCanvas().getWidth() - 50.0f, y + 17, Alignment.CENTER);
    }

    public void addMarios(int amount) {
        for (int i = 0; i < amount; ++i) {
            Sprite marioSprite = this.createMarioSprite();
            this.marios.add(new Mario(marioSprite, new Rect(0.0f, 0.0f, this.renderer.getCanvas().getWidth(), this.renderer.getCanvas().getHeight())));
        }
    }

    private Sprite createMarioSprite() {
        Sprite marioSprite = new Sprite();
        for (String direction : DIRECTIONS) {
            List<Image> frames = this.marioImageAtlas.getSubImages(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4");
            Animation anim = new Animation(frames, 0.1f, true);
            marioSprite.addState(direction, anim);
        }
        return marioSprite;
    }

    private void removeMarios(int amount) {
        for (int i = 0; i < amount && !this.marios.isEmpty(); ++i) {
            this.marios.remove(this.marios.size() - 1);
        }
    }

    private static class TouchMarker {
        private String text;
        private Point location;
        private int age;

        public TouchMarker(float x, float y) {
            this.text = Math.round(x) + ", " + Math.round(y);
            this.location = new Point(x, y);
        }
    }

    private static class Mario
    implements Updatable {
        private Sprite sprite;
        private Rect canvasBounds;
        private Point position;
        private int direction;
        private int speed;

        public Mario(Sprite sprite, Rect canvasBounds) {
            RandomGenerator random = new RandomGenerator();
            this.sprite = sprite;
            this.position = new Point(random.getFloat(0.0f, canvasBounds.getWidth()), random.getFloat(0.0f, canvasBounds.getHeight()));
            this.canvasBounds = canvasBounds;
            this.direction = random.getInt(0, 4);
            this.speed = random.getInt(1, 4);
        }

        @Override
        public void update(float deltaTime) {
            this.sprite.changeState(DIRECTIONS.get(this.direction));
            this.sprite.update(deltaTime);
            switch (this.direction) {
                case 0: {
                    this.position.add(0.0f, -this.speed);
                    break;
                }
                case 1: {
                    this.position.add(this.speed, 0.0f);
                    break;
                }
                case 2: {
                    this.position.add(0.0f, this.speed);
                    break;
                }
                case 3: {
                    this.position.add(-this.speed, 0.0f);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.checkBounds();
        }

        private void checkBounds() {
            if (this.position.getX() < 0.0f || this.position.getX() > this.canvasBounds.getWidth() || this.position.getY() < 0.0f || this.position.getY() > this.canvasBounds.getHeight()) {
                this.direction = (this.direction + 2) % 4;
            }
        }
    }
}

