/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.colorize.multimedialib.graphics.Image;

public class Animation {
    private List<Image> frames;
    private float frameDuration;
    private boolean loop;

    public Animation(List<Image> frames, float frameDuration, boolean loop) {
        Preconditions.checkArgument((!frames.isEmpty() ? 1 : 0) != 0, (Object)"Animation must consist of at least 1 frame");
        Preconditions.checkArgument((frames.size() == 1 || frameDuration > 0.0f ? 1 : 0) != 0, (Object)("Invalid frame duration: " + frameDuration));
        this.frames = ImmutableList.copyOf(frames);
        this.frameDuration = frameDuration;
        this.loop = loop;
    }

    public Animation(Image frame) {
        this((List<Image>)ImmutableList.of((Object)frame), 0.0f, false);
    }

    public Image getFrameAtIndex(int index) {
        return this.frames.get(index);
    }

    public Image getFrameAtTime(float time) {
        if (this.frames.size() == 1) {
            return this.frames.get(0);
        }
        if (this.loop && time > this.getDuration()) {
            time %= this.getDuration();
        }
        for (int frameIndex = 0; frameIndex < this.frames.size(); ++frameIndex) {
            float frameStartTime = (float)frameIndex * this.frameDuration;
            float frameEndTime = frameStartTime + this.frameDuration;
            if (!(time >= frameStartTime) || !(time < frameEndTime)) continue;
            return this.frames.get(frameIndex);
        }
        return this.frames.get(this.frames.size() - 1);
    }

    public float getDuration() {
        if (this.frames.size() == 1) {
            return 0.0f;
        }
        return (float)this.frames.size() * this.frameDuration;
    }

    public List<Image> getFrames() {
        return ImmutableList.copyOf(this.frames);
    }

    public float getFrameDuration() {
        return this.frameDuration;
    }

    public boolean isLoop() {
        return this.loop;
    }
}

