/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.math.Rect;

public class SpriteSheet {
    private Image image;
    private Map<String, Rect> regions;

    public SpriteSheet(Image image) {
        this.image = image;
        this.regions = new HashMap<String, Rect>();
    }

    public void markRegion(String name, Rect region) {
        Preconditions.checkArgument((boolean)new Rect(0.0f, 0.0f, this.image.getWidth(), this.image.getHeight()).contains(region), (Object)("Invalid region: " + region));
        this.regions.put(name, region);
    }

    public Image get(String name) {
        return this.image.getRegion(this.getRegion(name));
    }

    public Rect getRegion(String name) {
        Rect region = this.regions.get(name);
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)("Unknown region: " + region));
        return region;
    }

    public Set<String> getRegionNames() {
        return this.regions.keySet();
    }

    public Image getImage() {
        return this.image;
    }
}

