/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.graphics;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.graphics.ColorRGB;

public class Transform {
    private int rotation;
    private int scaleX;
    private int scaleY;
    private int alpha;
    private ColorRGB mask;

    public Transform() {
        this.reset();
    }

    public void reset() {
        this.rotation = 0;
        this.scaleX = 100;
        this.scaleY = 100;
        this.alpha = 100;
        this.mask = null;
    }

    public boolean isDefaultTransform() {
        return !this.isRotated() && !this.isScaled() && this.alpha == 100 && this.mask == null;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation % (rotation >= 0 ? 360 : -360);
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getRotationInRadians() {
        return (float)Math.toRadians(this.rotation);
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setScale(int scaleX, int scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    public void setScaleX(int scaleX) {
        Preconditions.checkArgument((scaleX >= 1 ? 1 : 0) != 0, (Object)("Invalid scale: " + scaleX));
        this.scaleX = scaleX;
    }

    public int getScaleX() {
        return this.scaleX;
    }

    public void setScaleY(int scaleY) {
        Preconditions.checkArgument((scaleY >= 1 ? 1 : 0) != 0, (Object)("Invalid scale: " + scaleY));
        this.scaleY = scaleY;
    }

    public int getScaleY() {
        return this.scaleY;
    }

    public boolean isScaled() {
        return this.scaleX != 100 || this.scaleY != 100;
    }

    public void setAlpha(int alpha) {
        Preconditions.checkArgument((alpha >= 0 && alpha <= 100 ? 1 : 0) != 0, (Object)("Invalid alpha: " + alpha));
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setMask(ColorRGB mask) {
        this.mask = mask;
    }

    public ColorRGB getMask() {
        return this.mask;
    }

    public boolean equals(Object o) {
        if (o instanceof Transform) {
            Transform other = (Transform)o;
            return this.rotation == other.rotation && this.scaleX == other.scaleX && this.scaleY == other.scaleY && this.alpha == other.alpha && Objects.equal((Object)this.mask, (Object)other.mask);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rotation, this.scaleX, this.scaleY, this.alpha, this.mask});
    }

    public static Transform withRotation(int rotation) {
        Transform transform = new Transform();
        transform.setRotation(rotation);
        return transform;
    }

    public static Transform withScale(int scaleX, int scaleY) {
        Transform transform = new Transform();
        transform.setScaleX(scaleX);
        transform.setScaleY(scaleY);
        return transform;
    }

    public static Transform withAlpha(int alpha) {
        Transform transform = new Transform();
        transform.setAlpha(alpha);
        return transform;
    }

    public static Transform withMask(ColorRGB mask) {
        Transform transform = new Transform();
        transform.setMask(mask);
        return transform;
    }
}

