/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import java.util.Objects;

public class Point {
    private float x;
    private float y;
    public static final float EPSILON = 0.001f;

    public Point(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Point p) {
        this.set(p.getX(), p.getY());
    }

    public void move(float deltaX, float deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public void add(float deltaX, float deltaY) {
        this.move(deltaX, deltaY);
    }

    public float calculateDistance(Point other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float calculateAngle(Point other) {
        if (this.equals(other)) {
            return 0.0f;
        }
        float deltaX = other.x - this.x;
        float deltaY = other.y - this.y;
        return (float)Math.toDegrees(Math.atan2(deltaY, deltaX));
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point other = (Point)o;
            return Math.abs(this.x - other.x) < 0.001f && Math.abs(this.y - other.y) < 0.001f;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return Math.round(this.x) + ", " + Math.round(this.y);
    }
}

