/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;

public class RandomGenerator {
    private Random generator = new Random();

    public int getInt(int min, int max) {
        Preconditions.checkArgument((max > min ? 1 : 0) != 0, (Object)("Invalid range: " + min + " - " + max));
        return min + this.generator.nextInt(max - min);
    }

    public float getFloat(float min, float max) {
        Preconditions.checkArgument((max > min ? 1 : 0) != 0, (Object)("Invalid range: " + min + " - " + max));
        return min + this.generator.nextFloat() * (max - min);
    }

    public boolean chance(float n) {
        Preconditions.checkArgument((n >= 0.0f && n <= 1.0f ? 1 : 0) != 0, (Object)("Number out of range: " + n));
        float value = this.generator.nextFloat();
        return n <= value;
    }

    public <T> T pick(List<T> elements) {
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"Cannot pick from empty list");
        int index = this.getInt(0, elements.size());
        return elements.get(index);
    }
}

