/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsContext;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Renderable;
import nl.colorize.multimedialib.scene.Updatable;

public abstract class AbstractRenderer
implements Renderer {
    private Canvas canvas;
    private List<Updatable> updateCallbacks;
    private List<Renderable> renderCallbacks;

    public AbstractRenderer(Canvas canvas) {
        this.canvas = canvas;
        this.updateCallbacks = new CopyOnWriteArrayList<Updatable>();
        this.renderCallbacks = new CopyOnWriteArrayList<Renderable>();
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void addUpdateCallback(Updatable callback) {
        this.updateCallbacks.add(callback);
    }

    protected void notifyUpdateCallbacks(float deltaTime) {
        for (Updatable callback : this.updateCallbacks) {
            callback.update(deltaTime);
        }
    }

    @Override
    public void addRenderCallback(Renderable callback) {
        this.renderCallbacks.add(callback);
    }

    protected void notifyRenderCallbacks(GraphicsContext graphics) {
        for (Renderable callback : this.renderCallbacks) {
            callback.render(graphics);
        }
    }
}

