/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;

public class Canvas {
    private int preferredWidth;
    private int preferredHeight;
    private float preferredZoomLevel;
    private int screenWidth;
    private int screenHeight;
    private int offsetX;
    private int offsetY;

    public Canvas(int preferredWidth, int preferredHeight, float zoomLevel) {
        Preconditions.checkArgument((preferredWidth > 0 && preferredHeight > 0 ? 1 : 0) != 0, (Object)("Invalid canvas dimensions: " + preferredWidth + "x" + preferredHeight));
        Preconditions.checkArgument((zoomLevel > 0.0f ? 1 : 0) != 0, (Object)("Invalid zoom level: " + zoomLevel));
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
        this.preferredZoomLevel = zoomLevel;
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public Canvas(int preferredWidth, int preferredHeight) {
        this(preferredWidth, preferredHeight, 1.0f);
    }

    public void resize(int screenWidth, int screenHeight) {
        Preconditions.checkArgument((screenWidth > 0 && screenHeight > 0 ? 1 : 0) != 0, (Object)("Invalid screen dimensions: " + screenWidth + "x" + screenHeight));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void offset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)(this.screenWidth - this.offsetX) / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)(this.screenHeight - this.offsetY) / this.getZoomLevel());
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public float getZoomLevel() {
        return this.preferredZoomLevel;
    }

    public int toCanvasX(int screenX) {
        return Math.round((float)(screenX - this.offsetX) / this.getZoomLevel());
    }

    public int toCanvasY(int screenY) {
        return Math.round((float)(screenY - this.offsetY) / this.getZoomLevel());
    }

    public int toScreenX(float canvasX) {
        return Math.round(canvasX * this.getZoomLevel() + (float)this.offsetX);
    }

    public int toScreenY(float canvasY) {
        return Math.round(canvasY * this.getZoomLevel() + (float)this.offsetY);
    }
}

