/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Charsets;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import nl.colorize.multimedialib.graphics.Audio;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.TrueTypeFont;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.renderer.java2d.JavaSoundPlayer;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.Utils2D;

public class StandardMediaLoader
implements MediaLoader {
    private Map<TrueTypeFont, Font> loadedFonts = new HashMap<TrueTypeFont, Font>();

    @Override
    public Image loadImage(FilePointer file) {
        try {
            ResourceFile source = new ResourceFile(file.getPath());
            BufferedImage loadedImage = Utils2D.loadImage((InputStream)source.openStream());
            BufferedImage compatibleImage = Utils2D.makeImageCompatible((BufferedImage)loadedImage);
            return new AWTImage(compatibleImage);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load image from " + file.getPath(), e);
        }
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new JavaSoundPlayer();
    }

    @Override
    public TrueTypeFont loadFont(String fontFamily, FilePointer file) {
        TrueTypeFont trueTypeFont;
        block8: {
            ResourceFile source = new ResourceFile(file.getPath());
            InputStream stream = source.openStream();
            try {
                Font awtFont = Font.createFont(0, stream);
                awtFont = awtFont.deriveFont(0, 12.0f);
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                env.registerFont(awtFont);
                TrueTypeFont font = new TrueTypeFont(awtFont.getFamily(), 12, ColorRGB.BLACK);
                this.loadedFonts.put(font, awtFont);
                trueTypeFont = font;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new MediaException("Cannot load font from " + file.getPath(), e);
                }
            }
            stream.close();
        }
        return trueTypeFont;
    }

    protected Font getFont(TrueTypeFont font) {
        Font awtFont = this.loadedFonts.get(font);
        if (awtFont == null) {
            awtFont = new Font(font.getFamily(), 0, font.getSize());
        }
        return awtFont;
    }

    @Override
    public String loadText(FilePointer file) {
        ResourceFile resourceFile = new ResourceFile(file.getPath());
        try {
            return resourceFile.read(Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load file: " + file);
        }
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return new ResourceFile(file.getPath()).exists();
    }
}

